/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.models.ReporteGeneral;
import com.example.sefinsa_app.utilities.ConnectedThread;
import com.example.sefinsa_app.utilities.NumeroLetras;
import com.example.sefinsa_app.utilities.PrinterCommands;
import com.example.sefinsa_app.utilities.Utils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class BluetoothUtils {
    public static BluetoothAdapter mBTAdapter = BluetoothAdapter.getDefaultAdapter();
    public static Set<BluetoothDevice> mPairedDevices;
    public static ArrayAdapter<String> mBTArrayAdapter;
    public static Context context;
    private static final UUID BT_MODULE_UUID;
    public static BluetoothDevice mmDevice;
    public static Handler mHandler;
    public static ConnectedThread mConnectedThread;
    public static BluetoothSocket mBTSocket;
    public static BroadcastReceiver BTReceiver;
    public static SharedPreferences sesion;
    private static final int MAX_WIDTH = 576;
    private static final int MAX_HEIGHT = 300;

    @SuppressLint(value={"MissingPermission"})
    public static BluetoothSocket createBluetoothSocket(BluetoothDevice device) throws IOException {
        try {
            Method m = device.getClass().getMethod("createInsecureRfcommSocketToServiceRecord", UUID.class);
            return (BluetoothSocket)m.invoke((Object)device, BT_MODULE_UUID);
        }
        catch (Exception e) {
            Log.e((String)"createBluetoothSocket", (String)"Could not create Insecure RFComm Connection", (Throwable)e);
            return device.createRfcommSocketToServiceRecord(BT_MODULE_UUID);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static void listPairedDevices(String deviceId) {
        mPairedDevices = mBTAdapter.getBondedDevices();
        if (mBTAdapter.isEnabled()) {
            for (BluetoothDevice device : mPairedDevices) {
                Log.d((String)"FadeMove", (String)("listPairedDevices: " + mPairedDevices.toArray()[0]));
                Log.d((String)"FadeMove", (String)("listPairedDevices: " + deviceId));
                mmDevice = device;
                if (!device.getName().equals(deviceId)) continue;
                mmDevice = device;
                break;
            }
            Toast.makeText((Context)context, (CharSequence)"Emparejando dispositivo", (int)0).show();
        } else {
            Toast.makeText((Context)context, (CharSequence)"Bluetooth apagado", (int)0).show();
        }
        Log.d((String)"DEVICE", (String)mmDevice.getName());
    }

    public static void initThread() {
        mHandler = new Handler(Looper.getMainLooper()){

            @SuppressLint(value={"MissingPermission"})
            public void handleMessage(Message msg) {
                if (msg.what == 2) {
                    String readMessage = null;
                    readMessage = new String((byte[])msg.obj, StandardCharsets.UTF_8);
                    Log.d((String)"readBuffer", (String)readMessage);
                }
                if (msg.what == 3) {
                    if (msg.arg1 == 1) {
                        Log.d((String)"BT STATUS", (String)"Connect");
                        Toast.makeText((Context)context, (CharSequence)("Conectado a " + mmDevice.getName()), (int)0).show();
                    } else {
                        Log.d((String)"BT STATUS", (String)"Fail");
                        Toast.makeText((Context)context, (CharSequence)("No se pudo conectar a " + mmDevice.getName()), (int)0).show();
                    }
                }
            }
        };
        new Thread(){

            @Override
            @SuppressLint(value={"MissingPermission"})
            public void run() {
                boolean fail = false;
                try {
                    mBTSocket = BluetoothUtils.createBluetoothSocket(mmDevice);
                }
                catch (IOException e) {
                    fail = true;
                    Toast.makeText((Context)context, (CharSequence)"ERROR SOCKET", (int)0).show();
                }
                try {
                    mBTSocket.connect();
                }
                catch (IOException e) {
                    try {
                        fail = true;
                        mBTSocket.close();
                        mHandler.obtainMessage(3, -1, -1).sendToTarget();
                    }
                    catch (IOException e2) {
                        Toast.makeText((Context)context, (CharSequence)"ERROR CHECK THREAD", (int)0).show();
                    }
                }
                if (!fail) {
                    mConnectedThread = new ConnectedThread(mBTSocket, mHandler, context);
                    mConnectedThread.start();
                    mHandler.obtainMessage(3, 1, -1, (Object)mmDevice.getName()).sendToTarget();
                }
            }
        }.start();
    }

    public static void closeThread() {
        if (mConnectedThread != null) {
            mConnectedThread.cancel();
        }
    }

    public static boolean isConnected() {
        try {
            Method m = mmDevice.getClass().getMethod("isConnected", null);
            boolean connected = (Boolean)m.invoke((Object)mmDevice, (Object[])null);
            return connected;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static void bluetoothOff() {
        mBTAdapter.disable();
        Toast.makeText((Context)context, (CharSequence)"Se apago Bluetooth", (int)0).show();
    }

    public static void printPhoto(int img) {
        try {
            Bitmap bmp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)img);
            if (bmp != null) {
                byte[] command = Utils.decodeBitmap(bmp);
                Log.d((String)"command", (String)("printPhoto: " + Arrays.toString(command)));
                BluetoothUtils.mConnectedThread.mmOutStream.write(PrinterCommands.ESC_ALIGN_CENTER);
                BluetoothUtils.mConnectedThread.mmOutStream.write(command);
            } else {
                Log.e((String)"Print Photo error", (String)"the file isn't exists");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"EXE", (String)e.toString());
            Log.e((String)"PrintTools", (String)"the file isn't exists");
        }
    }

    public static void printText(Pago pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "--------------------------\n";
            text = text + "Folio: " + folio + "\n";
            text = text + "Impresi\u00f3n: " + fechaConvert + "\n";
            text = text + "Ruta: " + pago.getNombre_ruta() + "\n";
            text = text + "Poblacion: " + pago.getNombre_poblacion() + "\n";
            text = text + "Recibi de: " + pago.getNombre_completo() + "\n";
            text = text + "Cantidad: $" + recibido + "\n";
            text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
            text = text + "Debe: $" + (Utils.convertirDouble(pago.getBalance()) - Utils.convertirDouble(recibido)) + "\n";
            if (pago_multa != "0.0") {
                text = text + "Multa: $" + pago_multa + "\n";
            }
            text = text + "Concepto: " + concepto + "\n";
            text = text + "--------------------------\n";
            mConnectedThread.write(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static void printText(Prestamo pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra) {
        try {
            if (BluetoothUtils.isConnected()) {
                String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
                String text = "--------------------------\n";
                text = text + "Folio: " + folio + "\n";
                text = text + fechaConvert + "\n";
                text = text + "Ruta: " + pago.getNombre_ruta() + "\n";
                text = text + "Poblacion: " + pago.getNombre_poblacion() + "\n";
                text = text + "Recibi de: " + pago.getNombre_completo() + "\n";
                text = text + "Cantidad: $" + recibido + "\n";
                text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
                if (pago_multa != "0.0") {
                    text = text + "Multa: $" + pago_multa + "\n";
                }
                text = text + "Concepto: " + concepto + "\n";
                text = text + "--------------------------\n";
                mConnectedThread.write(text);
            } else {
                Toast.makeText((Context)context, (CharSequence)("No se pudo conectar a " + mmDevice.getName()), (int)0).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=24)
    public static void printText(String titulo_ticket, String ruta_ticket, String Poblacion_ticket, String Nombre_ticket, String Atraso_ticket, String pago_ticket, String aviso, String aviso2, String empleado_ticket, String colocadora_ticket, String aval_ticket, String recargos_ticket, String monto_tot_ticket) {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());
            String text = "--------------------------\n";
            text = text + titulo_ticket + "\n";
            text = text + fechaConvert + "\n";
            text = text + ruta_ticket + "\n";
            text = text + Poblacion_ticket + "\n";
            text = text + colocadora_ticket + "\n";
            text = text + Nombre_ticket + "\n";
            text = text + aval_ticket + "\n";
            text = text + pago_ticket + "\n";
            text = text + Atraso_ticket + "\n";
            text = text + recargos_ticket + "\n";
            text = text + monto_tot_ticket + "\n";
            text = text + aviso + "\n";
            text = text + empleado_ticket + "\n";
            text = text + aviso2 + "\n";
            text = text + "--------------------------\n";
            mConnectedThread.write(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=26)
    @SuppressLint(value={"MissingPermission"})
    public static void printReimpresion(ReporteGeneral rg) throws ParseException {
        if (BluetoothUtils.isConnected()) {
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = inputFormat.parse(rg.getFecha_pago_realizada());
            String fechaConvert = outputFormat.format(date);
            NumeroLetras numeroLetras = new NumeroLetras();
            String recibido_con_letra = numeroLetras.Convertir(rg.getPago(), "", "", "", "", "", true);
            String text = "--------------------------\n";
            text = text + "Folio: " + (rg.getFolio() == null ? "" : rg.getFolio()) + "\n";
            text = text + "Reimpresion: " + fechaConvert + "\n";
            text = text + "Ruta: " + rg.getNombre_ruta() + "\n";
            text = text + "Poblacion: " + rg.getNombre_poblacion() + "\n";
            text = text + "Recibi de: " + rg.getNombre_completo() + "\n";
            text = text + "Cantidad: $" + rg.getPago() + "\n";
            text = text + "(" + recibido_con_letra + "PESOS 00/100 MN)\n";
            if (rg.getPago_multa() != "0.00") {
                text = text + "Multa: $" + rg.getPago_multa() + "\n";
            }
            text = text + "Concepto: " + (rg.getConcepto() == null ? "" : rg.getConcepto()) + "\n";
            text = text + "--------------------------\n";
            mConnectedThread.write(text);
            Log.d((String)"REIMRPRESION", (String)text);
        } else {
            Toast.makeText((Context)context, (CharSequence)("No se pudo conectar a " + mmDevice.getName()), (int)0).show();
        }
    }

    @RequiresApi(api=26)
    @SuppressLint(value={"MissingPermission"})
    public static void printReimpresion(Folio folio, String ruta, String poblacion, String cliente, Bitmap fa, Bitmap fc) throws ParseException, IOException {
        cliente = cliente.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
        String concepto = folio.getConcepto().replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
        if (BluetoothUtils.isConnected()) {
            String text = "--------------------------\n";
            text = text + "PRESTAMO GRUSEF S.A. de C.V.\n";
            text = text + "Folio: " + folio.getId() + "\n";
            text = text + "Fecha: " + folio.getFecha() + "\n";
            text = text + "Ruta: " + ruta + "\n";
            text = text + "Poblacion: \n" + poblacion + "\n";
            text = text + "Recibi de:\n" + cliente + "\n";
            text = text + "Cantidad: $" + folio.getMonto() + "\n";
            text = text + folio.getMonto_letra();
            text = text + "\nConcepto: \n";
            text = text + concepto;
            mConnectedThread.write(text);
            mConnectedThread.write("\nFirma del administrador: \n");
            Log.d((String)"firmas", (String)fa.toString());
            BluetoothUtils.printBitmap(fa);
            mConnectedThread.write("Firma de la colocadora: \n");
            Log.d((String)"firmas", (String)fc.toString());
            BluetoothUtils.printBitmap(fc);
            mConnectedThread.write("--------------------------\n\n");
        } else {
            Toast.makeText((Context)context, (CharSequence)("No se pudo conectar a " + mmDevice.getName()), (int)0).show();
        }
    }

    @RequiresApi(api=26)
    @SuppressLint(value={"MissingPermission"})
    public static void imprimirRMD(RMD rmd) throws ParseException, IOException {
        String folio = rmd.getId();
        String noCuenta = rmd.getNumeroCuenta();
        String nombre = rmd.getNombre();
        String telefono = rmd.getTelefono();
        String ruta = rmd.getRuta();
        String poblacion = rmd.getPoblacion();
        String fecha = rmd.getFecha();
        ArrayList<Articulo> articulos = rmd.getArticulos();
        String valorGarantia = rmd.getValorGarantia();
        String pagara = rmd.getPagara();
        String fechaIns = rmd.getFechaIns();
        String recibeMercancia = rmd.getRecibeMercancia();
        String firmaCliente = rmd.getFirmaCliente();
        String firmaAsesor = rmd.getFirmaAsesor();
        nombre = nombre.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
        recibeMercancia = recibeMercancia.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
        if (BluetoothUtils.isConnected()) {
            StringBuilder text = new StringBuilder("--------------------------\n");
            text.append("PRESTAMO GRUSEF S.A. de C.V.\n");
            text.append("Folio: ").append(folio).append("\n");
            text.append("Fecha: ").append(fecha).append("\n");
            text.append("No. Cuenta: ").append(noCuenta).append("\n");
            text.append("Nombre: ").append(nombre).append("\n");
            text.append("Telefono: ").append(telefono).append("\n");
            text.append("Ruta: ").append(ruta).append("\n");
            text.append("Poblacion:\n").append(poblacion).append("\n\n");
            text.append("Debido a que de inmediano no me\npuedo poner al corriente en los\npagos que me obligue a hacer en\nmi cuenta conforme al contrato\nfirmado que celebre con ustedes,\nhago entrega de las siguientes\ngarantias:\n\n");
            int i = 1;
            for (Articulo articulo : articulos) {
                String nombreArticulo = articulo.getArticulo();
                String marca = articulo.getMarca();
                String color2 = articulo.getColor();
                String condiciones = articulo.getDetalleCondiciones();
                nombreArticulo = nombreArticulo.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
                marca = marca.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
                color2 = color2.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
                condiciones = condiciones.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u00fc", "u").replace("\u00dc", "U");
                nombreArticulo = BluetoothUtils.configurar32Caracteres(nombreArticulo, "Nombre");
                marca = BluetoothUtils.configurar32Caracteres(marca, "Marca");
                color2 = BluetoothUtils.configurar32Caracteres(color2, "Color");
                condiciones = BluetoothUtils.configurar32Caracteres(condiciones, "");
                text.append("Articulo ").append(i).append("\n");
                text.append("Nombre: ").append(nombreArticulo).append("\n");
                text.append("Marca: ").append(marca).append("\n");
                text.append("Color: ").append(color2).append("\n");
                text.append("Condiciones:\n").append(condiciones).append("\n\n");
                ++i;
            }
            text.append("Valor garantia: $").append(valorGarantia).append("\n");
            text.append("Pagara: $").append(pagara).append("\n");
            text.append("Fecha: ").append(fechaIns).append("\n");
            text.append("Recibe mercancia:\n").append(recibeMercancia).append("\n\n");
            text.append("Y LIQUIDARA EL ADEUDO EN LAS\nPROXIMAS 24 HORAS. DE INCUMPLIR\nCON DICHO ACUERDO ACEPTO QUE MIS\nGARANTIAS SEAN VENDIDAS PARA\nCUBRIR EL IMPORTE MENCIONADO EN\nEL VALOR DE GARANTIA.\n\n");
            mConnectedThread.write(text.toString());
            Bitmap bmFirmaCliente = BluetoothUtils.base64ToBitmap(firmaCliente);
            Bitmap bmFirmaAsesor = BluetoothUtils.base64ToBitmap(firmaAsesor);
            mConnectedThread.write("Firma del cliente:\n");
            BluetoothUtils.printBitmap(bmFirmaCliente);
            mConnectedThread.write("Firma del asesor:\n");
            BluetoothUtils.printBitmap(bmFirmaAsesor);
            mConnectedThread.write("--------------------------\n\n");
        }
    }

    private static String configurar32Caracteres(String texto, String x) {
        String[] palabras = texto.split(" ");
        StringBuilder resultado = new StringBuilder();
        int countLinea = 0;
        if (Objects.equals(x, "Nombre")) {
            countLinea = 8;
        }
        if (Objects.equals(x, "Marca")) {
            countLinea = 7;
        }
        if (Objects.equals(x, "Color")) {
            countLinea = 7;
        }
        for (String palabra : palabras) {
            Log.d((String)"32chars", (String)((countLinea += palabra.length() + 1) + " " + palabra));
            if (countLinea > 32) {
                resultado.append("\n");
                countLinea = 0;
            }
            resultado.append(palabra).append(" ");
        }
        return resultado.toString().trim();
    }

    private static Bitmap base64ToBitmap(String base64) {
        byte[] decodedBytes = Base64.decode((String)base64, (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
    }

    public static Bitmap scaleAndConvertToBW(Bitmap original) {
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();
        int targetWidth = Math.min(originalWidth, 576);
        int targetHeight = Math.min(originalHeight, 300);
        float aspectRatio = (float)originalWidth / (float)originalHeight;
        if (originalWidth > originalHeight) {
            targetHeight = (int)((float)targetWidth / aspectRatio);
        } else {
            targetWidth = (int)((float)targetHeight * aspectRatio);
        }
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)original, (int)targetWidth, (int)targetHeight, (boolean)true);
        return BluetoothUtils.convertToBlackWhite(scaledBitmap);
    }

    public static Bitmap convertToBlackWhite(Bitmap original) {
        int width = original.getWidth();
        int height = original.getHeight();
        Bitmap bwBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = original.getPixel(x, y);
                int gray = (Color.red((int)pixel) + Color.green((int)pixel) + Color.blue((int)pixel)) / 3;
                int bw = gray < 128 ? -16777216 : -1;
                bwBitmap.setPixel(x, y, bw);
            }
        }
        return bwBitmap;
    }

    public static void printBitmap(Bitmap bmp) {
        Log.d((String)"height", (String)("printBitmap: " + bmp.getHeight()));
        Log.d((String)"width", (String)("printBitmap: " + bmp.getWidth()));
        try {
            if (bmp != null) {
                Bitmap processedBitmap = BluetoothUtils.scaleAndConvertToBW(bmp);
                byte[] command = Utils.decodeBitmap(processedBitmap);
                if (command == null) {
                    Log.e((String)"PrintTools", (String)"decodeBitmap returned null. Bitmap might be too large or incompatible.");
                    return;
                }
                BluetoothUtils.mConnectedThread.mmOutStream.write(PrinterCommands.ESC_ALIGN_CENTER);
                BluetoothUtils.mConnectedThread.mmOutStream.write(command);
            } else {
                Log.e((String)"PrintTools", (String)"Bitmap is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"PrintTools", (String)("Error printing bitmap: " + e.getMessage()));
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresApi(api=24)
    public static void printReporteGeneral(ArrayList<ReporteGeneral> reporteGeneral, String fecha) {
        try {
            sesion = context.getSharedPreferences("sesion", 0);
            if (BluetoothUtils.isConnected()) {
                String text = "\nREPORTE GENERAL " + fecha + "\n\n";
                text = text + sesion.getString("nombre", "") + "\n\n";
                double total = 0.0;
                for (ReporteGeneral rg : reporteGeneral) {
                    total += Utils.convertirDouble(rg.getPago());
                }
                text = text + "TOTAL: $" + total + "\n\n";
                Map<String, List<ReporteGeneral>> reporteGeneralGroup = reporteGeneral.stream().collect(Collectors.groupingBy(w -> w.getNombre_poblacion()));
                for (Map.Entry<String, List<ReporteGeneral>> entry : reporteGeneralGroup.entrySet()) {
                    String key = entry.getKey();
                    List<ReporteGeneral> value = entry.getValue();
                    text = text + key + "\n";
                    for (int i = 0; i < value.size(); ++i) {
                        text = text + value.get(i).getNombre_completo() + ": $" + value.get(i).getPago() + " ";
                        text = text + (value.get(i).getFolio() == null ? "" : value.get(i).getFolio()) + " " + (value.get(i).getConcepto() == null ? "" : value.get(i).getConcepto()) + "\n\n";
                    }
                }
                Log.d((String)"REPORTE", (String)text);
                mConnectedThread.write(text);
            } else {
                Toast.makeText((Context)context, (CharSequence)("No se pudo conectar a " + mmDevice.getName()), (int)0).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public static void broadcastReceiver() {
        BTReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    mBTArrayAdapter.add((Object)(mmDevice.getName() + "\n" + mmDevice.getAddress()));
                    mBTArrayAdapter.notifyDataSetChanged();
                }
            }
        };
    }

    static {
        BT_MODULE_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
        mBTSocket = null;
    }
}

