/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientesAdapter
extends RecyclerView.Adapter<ClientesViewHolder> {
    Context context;
    ArrayList<Cliente> clientes;
    private final SharedPreferences sesion;
    private String cliente_id;
    private VolleyS vs;
    private RequestQueue requestQueue;

    public ClientesAdapter(Context context, ArrayList<Cliente> clientes) {
        this.context = context;
        this.clientes = clientes;
        this.sesion = context.getSharedPreferences("sesion", 0);
    }

    public void setListaFiltrada(ArrayList<Cliente> listaFiltrada) {
        this.clientes = listaFiltrada != null ? listaFiltrada : new ArrayList();
        this.notifyDataSetChanged();
    }

    @NonNull
    public ClientesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(2131492905, parent, false);
        return new ClientesViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ClientesViewHolder holder, int position) {
        try {
            if (this.clientes == null || position < 0 || position >= this.clientes.size()) {
                Log.e((String)"ClientesAdapter", (String)("Datos no v\u00e1lidos en la posici\u00f3n: " + position));
                holder.imprimirDefault();
                return;
            }
            Cliente cliente = this.clientes.get(position);
            if (cliente == null) {
                Log.e((String)"ClientesAdapter", (String)("Cliente nulo en posici\u00f3n: " + position));
                holder.imprimirDefault();
            } else {
                holder.imprimir(position);
            }
        }
        catch (Exception e) {
            Log.e((String)"ClientesAdapter", (String)"Error en onBindViewHolder", (Throwable)e);
        }
    }

    public int getItemCount() {
        return this.clientes.size();
    }

    public void clear() {
        this.clientes.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<Cliente> list) {
        if (list != null) {
            this.clientes.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    private void refreshData() {
        this.requestQueue.getCache().clear();
    }

    private String formatFecha(String fecha) {
        if (fecha == null) {
            return "...";
        }
        SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat desiredFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        try {
            Date date = originalFormat.parse(fecha);
            return desiredFormat.format(date);
        }
        catch (ParseException | java.text.ParseException e) {
            e.printStackTrace();
            return "...";
        }
    }

    public void activarPrestanombre(String clientId) {
        VolleyS vs = VolleyS.getInstance(this.context);
        RequestQueue requestQueue = vs.getRequestQueue();
        requestQueue.getCache().clear();
        JSONObject data = new JSONObject();
        try {
            data.put("func", (Object)"prestanombre_activar");
            data.put("id", (Object)clientId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)"4", (String)"loadAllData: ");
        JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                try {
                    String status = response.getString("status");
                    if (status.equals("success")) {
                        Toast.makeText((Context)ClientesAdapter.this.context, (CharSequence)"Cliente actualizado", (int)0).show();
                        Log.d((String)"DEBUG", (String)("Respuesta del servidor: " + status));
                    } else {
                        Toast.makeText((Context)ClientesAdapter.this.context, (CharSequence)"Error en la activaci\u00f3n del prestanombre", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Toast.makeText((Context)ClientesAdapter.this.context, (CharSequence)"Error al procesar la respuesta", (int)0).show();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Toast.makeText((Context)ClientesAdapter.this.context, (CharSequence)"Error en la solicitud", (int)0).show();
            }
        });
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
        requestQueue.add((Request)request);
    }

    public class ClientesViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvNombreCliente;
        TextView tvDireccionCliente;
        TextView tvTelefonoCliente;
        TextView tvRutaCliente;
        TextView tvPoblacionCliente;
        TextView tvColocadoraCliente;
        TextView tvGarantiasCliente;
        Button btnEditarCliente;
        Button btnVerInfoCliente;
        Button btnGenerarPrestamo;
        Button btnVerImagenes;
        Button btnPrestanombre;
        String informacion;
        ConstraintLayout tarjetaCliente;
        int prestan;

        public void imprimirDefault() {
            if (this.tvNombreCliente != null) {
                this.tvNombreCliente.setText((CharSequence)"Nombre Predeterminado");
            }
            if (this.tvTelefonoCliente != null) {
                this.tvTelefonoCliente.setText((CharSequence)"0000000000");
            }
            if (this.tvDireccionCliente != null) {
                this.tvDireccionCliente.setText((CharSequence)"Direccion no disponible");
            }
            if (this.tvRutaCliente != null) {
                this.tvRutaCliente.setText((CharSequence)"Ruta no disponible");
            }
            if (this.tvPoblacionCliente != null) {
                this.tvPoblacionCliente.setText((CharSequence)"Poblaci\u00f3n no disponible");
            }
            if (this.tvColocadoraCliente != null) {
                this.tvColocadoraCliente.setText((CharSequence)"Colocadora no disponible");
            }
            if (this.tvGarantiasCliente != null) {
                this.tvGarantiasCliente.setText((CharSequence)"Garant\u00edas no disponibles");
            }
            if (this.btnPrestanombre != null) {
                this.btnPrestanombre.setVisibility(0);
            }
        }

        public ClientesViewHolder(View itemView) {
            super(itemView);
            this.informacion = "";
            this.prestan = 0;
            this.tarjetaCliente = (ConstraintLayout)itemView.findViewById(2131296273);
            this.tvNombreCliente = (TextView)itemView.findViewById(2131296891);
            this.tvDireccionCliente = (TextView)itemView.findViewById(2131296546);
            this.tvTelefonoCliente = (TextView)itemView.findViewById(2131297127);
            this.tvRutaCliente = (TextView)itemView.findViewById(2131296971);
            this.tvPoblacionCliente = (TextView)itemView.findViewById(2131296935);
            this.tvColocadoraCliente = (TextView)itemView.findViewById(2131296501);
            this.tvGarantiasCliente = (TextView)itemView.findViewById(2131296659);
            this.btnEditarCliente = (Button)itemView.findViewById(2131296421);
            this.btnVerInfoCliente = (Button)itemView.findViewById(2131296463);
            this.btnGenerarPrestamo = (Button)itemView.findViewById(2131296431);
            this.btnVerImagenes = (Button)itemView.findViewById(2131296460);
            this.btnPrestanombre = (Button)itemView.findViewById(2131296445);
        }

        private void showAlert(String message) {
            AlertDialog.Builder builder = new AlertDialog.Builder(ClientesAdapter.this.context);
            builder.setMessage((CharSequence)message);
            TextView title = new TextView(ClientesAdapter.this.context);
            title.setText((CharSequence)"Alerta");
            title.setGravity(17);
            title.setTextSize(2, 20.0f);
            title.setTextColor(ContextCompat.getColor((Context)ClientesAdapter.this.context, (int)17170444));
            title.setPadding(0, 20, 0, 20);
            builder.setCustomTitle((View)title);
            builder.setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }

        public void imprimir(final int position) {
            if (position >= 0 && position < ClientesAdapter.this.clientes.size()) {
                Cliente cliente = ClientesAdapter.this.clientes.get(position);
                String nombreAval = cliente.getNombre_aval();
                if (cliente != null) {
                    this.prestan = Integer.parseInt(cliente.getPrestanombre());
                    if (this.prestan > 0) {
                        this.tarjetaCliente.setBackgroundColor(ContextCompat.getColor((Context)ClientesAdapter.this.context, (int)2131099698));
                        this.btnPrestanombre.setVisibility(8);
                    } else {
                        this.btnPrestanombre.setVisibility(0);
                        this.tarjetaCliente.setBackgroundColor(ContextCompat.getColor((Context)ClientesAdapter.this.context, (int)2131099771));
                    }
                    this.tvNombreCliente.setText((CharSequence)(cliente.getNombre_completo() + "\nAVAL: " + nombreAval));
                    this.tvTelefonoCliente.setText((CharSequence)cliente.getTelefono());
                    this.tvRutaCliente.setText((CharSequence)cliente.getNombre_ruta());
                    this.informacion = "<b>Cliente:</b> " + cliente.getNombre_completo() + " <br><br> <b>Direcci\u00f3n:</b> " + cliente.getDireccion() + " <br><br> <b>Tel\u00e9fono:</b> <a href='tel:" + cliente.getTelefono() + "'>" + cliente.getTelefono() + "</a><br><br> <b>Colocadora:</b> " + cliente.getNombre_colocadora() + " <br><br> <b>Poblaci\u00f3n:</b> " + cliente.getNombre_poblacion() + " <br><br> <b>Garant\u00edas:</b> " + cliente.getGarantias() + " <br><br><br><b>Aval:</b> " + nombreAval + " <br><br> <b>Direcci\u00f3n:</b> " + cliente.getDireccion_aval() + " <br><br> <b>Tel\u00e9fono:</b> " + cliente.getTelefono_aval() + " <br><br> <b>Otras referencias:</b> " + cliente.getOtras_referencias_aval() + " <br><br> <b>Garant\u00edas:</b> " + cliente.getGarantias_aval() + " <br><br> ";
                }
                int desiredWidth = 74;
                float scale = ClientesAdapter.this.context.getResources().getDisplayMetrics().density;
                int desiredWidthPx = (int)((float)desiredWidth * scale + 0.5f);
                ViewGroup.LayoutParams paramsVerInfo = this.btnVerInfoCliente.getLayoutParams();
                paramsVerInfo.width = desiredWidthPx;
                this.btnVerInfoCliente.setLayoutParams(paramsVerInfo);
                ViewGroup.LayoutParams paramsEditarCliente = this.btnEditarCliente.getLayoutParams();
                paramsEditarCliente.width = desiredWidthPx;
                this.btnEditarCliente.setLayoutParams(paramsEditarCliente);
                ViewGroup.LayoutParams paramsGenerarPrestamo = this.btnGenerarPrestamo.getLayoutParams();
                paramsGenerarPrestamo.width = desiredWidthPx;
                this.btnGenerarPrestamo.setLayoutParams(paramsGenerarPrestamo);
                ViewGroup.LayoutParams paramsPrestanombre = this.btnPrestanombre.getLayoutParams();
                paramsPrestanombre.width = desiredWidthPx;
                this.btnPrestanombre.setLayoutParams(paramsPrestanombre);
                ViewGroup.LayoutParams paramsVerImagenes = this.btnVerImagenes.getLayoutParams();
                paramsVerImagenes.width = desiredWidthPx;
                this.btnVerImagenes.setLayoutParams(paramsVerImagenes);
                if (ClientesAdapter.this.sesion.getString("nombre_perfil", "").equals("Administrador") || ClientesAdapter.this.sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {
                    this.btnEditarCliente.setVisibility(0);
                    this.btnGenerarPrestamo.setVisibility(0);
                } else if (!ClientesAdapter.this.sesion.getString("nombre_perfil", "").equals("VOCERO")) {
                    if (ClientesAdapter.this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || ClientesAdapter.this.sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                        this.btnEditarCliente.setVisibility(8);
                    } else {
                        this.btnGenerarPrestamo.setVisibility(8);
                        this.btnEditarCliente.setVisibility(0);
                    }
                }
                this.btnVerImagenes.setVisibility(0);
                this.btnGenerarPrestamo.setOnClickListener(view -> {
                    if (this.prestan > 0) {
                        this.showAlert("\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                    } else {
                        Bundle args = new Bundle();
                        String personJsonString = Utils.getGsonParser().toJson((Object)ClientesAdapter.this.clientes.get(position));
                        args.putString("cliente", personJsonString);
                        Navigation.findNavController((Activity)((Activity)ClientesAdapter.this.context), (int)2131296862).navigate(2131296867, args);
                    }
                });
                this.btnVerImagenes.setOnClickListener(view -> {
                    CharSequence[] opciones = new String[]{"Tomar fotos", "Ver expediente"};
                    new MaterialAlertDialogBuilder(ClientesAdapter.this.context).setTitle((CharSequence)"Opciones").setSingleChoiceItems(opciones, -1, (dialogInterface, i) -> {
                        switch (i) {
                            case 0: {
                                dialogInterface.dismiss();
                                ClientesAdapter.this.cliente_id = ClientesAdapter.this.clientes.get((int)position).id;
                                Log.d((String)"LISTA0", (String)("DATO DE cliente_id para foto...................: " + ClientesAdapter.this.cliente_id));
                                Bundle args2 = new Bundle();
                                String personJsonString2 = Utils.getGsonParser().toJson((Object)ClientesAdapter.this.clientes.get(position));
                                String personJsonString4 = nombreAval;
                                args2.putString("cliente", personJsonString2);
                                args2.putString("avalNombre", personJsonString4);
                                Log.d((String)"oasjksajk", (String)("imprimir: " + cliente.getAval_id() + " " + cliente.getNombre_aval()));
                                if (Objects.equals(cliente.getNombre_aval(), "") || cliente.getNombre_aval() == null) {
                                    Navigation.findNavController((Activity)((Activity)ClientesAdapter.this.context), (int)2131296862).navigate(2131296854, args2);
                                    break;
                                }
                                Navigation.findNavController((Activity)((Activity)ClientesAdapter.this.context), (int)2131296862).navigate(2131296850, args2);
                                break;
                            }
                            case 1: {
                                dialogInterface.dismiss();
                                Bundle args = new Bundle();
                                String personJsonString = Utils.getGsonParser().toJson((Object)ClientesAdapter.this.clientes.get(position));
                                String personJsonString3 = ClientesAdapter.this.clientes.get((int)position).id;
                                Log.d((String)"LISTA1", (String)("DATO DE SUCESS personJsonString: " + personJsonString));
                                args.putString("cliente", personJsonString);
                                args.putString("clienteId", personJsonString3);
                                Navigation.findNavController((Activity)((Activity)ClientesAdapter.this.context), (int)2131296862).navigate(2131296852, args);
                            }
                        }
                    }).show();
                });
                this.btnEditarCliente.setOnClickListener(view -> {
                    Bundle args = new Bundle();
                    String personJsonString = Utils.getGsonParser().toJson((Object)ClientesAdapter.this.clientes.get(position));
                    args.putString("cliente", personJsonString);
                    Navigation.findNavController((Activity)((Activity)ClientesAdapter.this.context), (int)2131296862).navigate(2131296853, args);
                });
                this.btnPrestanombre.setOnClickListener(view -> new AlertDialog.Builder(ClientesAdapter.this.context).setTitle((CharSequence)"Presta Nombres").setCancelable(false).setMessage((CharSequence)"\u00bfDesea marcar al cliente como prestanombre?").setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        ConnectivityManager connectivityManager = (ConnectivityManager)ClientesAdapter.this.context.getSystemService("connectivity");
                        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                        if (activeNetworkInfo == null || !activeNetworkInfo.isConnected()) {
                            Toast.makeText((Context)ClientesAdapter.this.context, (CharSequence)"No hay conexi\u00f3n de red", (int)0).show();
                            return;
                        }
                        String clientId = ClientesAdapter.this.clientes.get(position).getId();
                        ClientesAdapter.this.activarPrestanombre(clientId);
                        ClientesViewHolder.this.tarjetaCliente.setBackgroundColor(ContextCompat.getColor((Context)ClientesAdapter.this.context, (int)2131099698));
                        ClientesViewHolder.this.btnPrestanombre.setVisibility(8);
                        ClientesAdapter.this.clientes.get(position).setPrestanombre("1");
                        ClientesViewHolder.this.prestan = Integer.parseInt(ClientesAdapter.this.clientes.get(position).getPrestanombre());
                    }
                }).setNegativeButton((CharSequence)"CANCELAR", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                    }
                }).show());
                this.btnVerInfoCliente.setOnClickListener(view -> {
                    View dialogView = LayoutInflater.from((Context)ClientesAdapter.this.context).inflate(2131492936, null, false);
                    TextView tvNombreCliente = (TextView)dialogView.findViewById(2131297313);
                    TextView tvDireccionCliente = (TextView)dialogView.findViewById(2131297283);
                    TextView tvTelefonoCliente = (TextView)dialogView.findViewById(2131297334);
                    TextView tvColocadoraCliente = (TextView)dialogView.findViewById(2131297274);
                    TextView tvPoblacionCliente = (TextView)dialogView.findViewById(2131297320);
                    TextView tvGarantiasCliente = (TextView)dialogView.findViewById(2131297295);
                    TextView tvUbicacionCliente = (TextView)dialogView.findViewById(2131297339);
                    TextView tvNombreAval = (TextView)dialogView.findViewById(2131297311);
                    final TextView tvMapaCliente = (TextView)dialogView.findViewById(2131297303);
                    final TextView tvMapaAval = (TextView)dialogView.findViewById(2131297302);
                    TextView tvUpdGarantiasCliente = (TextView)dialogView.findViewById(2131297345);
                    TextView tvUpdComprobantesCliente = (TextView)dialogView.findViewById(2131297342);
                    TextView tvUpdGarantiasAval = (TextView)dialogView.findViewById(2131297343);
                    TextView tvUpdComprobantesAval = (TextView)dialogView.findViewById(2131297340);
                    TextView tvDireccionAval = (TextView)dialogView.findViewById(2131297281);
                    TextView tvTelefonoAval = (TextView)dialogView.findViewById(2131297332);
                    TextView tvORAval = (TextView)dialogView.findViewById(2131297314);
                    TextView tvGarantiasAval = (TextView)dialogView.findViewById(2131297293);
                    tvNombreCliente.setText((CharSequence)Html.fromHtml((String)("<b>Cliente:</b> " + ClientesAdapter.this.clientes.get(position).getNombre_completo())));
                    tvDireccionCliente.setText((CharSequence)Html.fromHtml((String)("<b>Direcci\u00f3n:</b> " + ClientesAdapter.this.clientes.get(position).getDireccion())));
                    tvTelefonoCliente.setText((CharSequence)Html.fromHtml((String)("<b>Tel\u00e9fono:</b> " + ClientesAdapter.this.clientes.get(position).getTelefono())));
                    tvMapaCliente.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n</b>"));
                    tvMapaAval.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n</b>"));
                    tvColocadoraCliente.setText((CharSequence)Html.fromHtml((String)("<b>Colocadora:</b> " + ClientesAdapter.this.clientes.get(position).getNombre_colocadora())));
                    tvPoblacionCliente.setText((CharSequence)Html.fromHtml((String)("<b>Poblaci\u00f3n:</b> " + ClientesAdapter.this.clientes.get(position).getNombre_poblacion())));
                    tvGarantiasCliente.setText((CharSequence)Html.fromHtml((String)("<b>Garant\u00edas:</b> " + ClientesAdapter.this.clientes.get(position).getGarantias())));
                    ClientesAdapter.this.vs = VolleyS.getInstance(ClientesAdapter.this.context);
                    ClientesAdapter.this.requestQueue = ClientesAdapter.this.vs.getRequestQueue();
                    JSONObject data = new JSONObject();
                    try {
                        data.put("func", (Object)"getCords");
                        data.put("id", (Object)ClientesAdapter.this.clientes.get(position).getId());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)"12", (String)"loadAllData: ");
                    JsonObjectRequest req = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

                        public void onResponse(JSONObject response) {
                            try {
                                if (!response.get("data").toString().equals("false")) {
                                    JSONObject jsonObject = (JSONObject)response.get("data");
                                    final String latitud = jsonObject.getString("latitud");
                                    final String longitud = jsonObject.getString("longitud");
                                    if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                        tvMapaCliente.setText((CharSequence)"");
                                    } else {
                                        tvMapaCliente.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View v) {
                                                Intent intent = new Intent("android.intent.action.VIEW");
                                                intent.setData(Uri.parse((String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud)));
                                                intent.setPackage("com.google.android.apps.maps");
                                                ClientesAdapter.this.context.startActivity(intent);
                                            }
                                        });
                                    }
                                }
                            }
                            catch (JSONException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                        }
                    });
                    ClientesAdapter.this.requestQueue.add((Request)req);
                    JSONObject data2 = new JSONObject();
                    try {
                        data2.put("func", (Object)"coordenadasAval");
                        data2.put("aval_id", (Object)ClientesAdapter.this.clientes.get(position).getAval_id());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)"coordenadasAval", (String)data2.toString());
                    Log.d((String)"13", (String)"loadAllData: ");
                    JsonObjectRequest req2 = new JsonObjectRequest(1, API.urlClientes, data2, (Response.Listener)new Response.Listener<JSONObject>(){

                        public void onResponse(JSONObject response) {
                            try {
                                if (!response.get("data").toString().equals("false")) {
                                    JSONObject jsonObject = (JSONObject)response.get("data");
                                    final String latitud = jsonObject.getString("latitud");
                                    final String longitud = jsonObject.getString("longitud");
                                    if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                        tvMapaAval.setText((CharSequence)"");
                                    } else {
                                        tvMapaAval.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View v) {
                                                Log.d((String)"qpwopeoqpww", (String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                Intent intent = new Intent("android.intent.action.VIEW");
                                                intent.setData(Uri.parse((String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud)));
                                                intent.setPackage("com.google.android.apps.maps");
                                                ClientesAdapter.this.context.startActivity(intent);
                                            }
                                        });
                                    }
                                }
                            }
                            catch (JSONException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                        }
                    });
                    ClientesAdapter.this.requestQueue.add((Request)req2);
                    Log.d((String)"MyWorker", (String)("INFORMACION EN CLIENTE SELECCIONADO........" + ClientesAdapter.this.clientes.get(position).getUpdate_comprobantes_cliente() + " / " + ClientesAdapter.this.clientes.get(position).getUpdate_garantias_cliente()));
                    String updateGarantiasCliente = ClientesAdapter.this.clientes.get(position).getUpdate_garantias_cliente();
                    String updateComprobantesCliente = ClientesAdapter.this.clientes.get(position).getUpdate_comprobantes_cliente();
                    updateGarantiasCliente = updateGarantiasCliente != null ? updateGarantiasCliente : "...";
                    updateComprobantesCliente = updateComprobantesCliente != null ? updateComprobantesCliente : "...";
                    String updateGarantiasAval = ClientesAdapter.this.clientes.get(position).getUpdate_garantias_aval();
                    String updateComprobantesAval = ClientesAdapter.this.clientes.get(position).getUpdate_comprobantes_aval();
                    updateComprobantesAval = updateComprobantesAval != null ? updateComprobantesAval : "...";
                    updateGarantiasAval = updateGarantiasAval != null ? updateGarantiasAval : "...";
                    updateGarantiasCliente = ClientesAdapter.this.formatFecha(updateGarantiasCliente);
                    updateComprobantesCliente = ClientesAdapter.this.formatFecha(updateComprobantesCliente);
                    updateGarantiasAval = ClientesAdapter.this.formatFecha(updateGarantiasAval);
                    updateComprobantesAval = ClientesAdapter.this.formatFecha(updateComprobantesAval);
                    tvUpdGarantiasCliente.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Garant\u00edas:</b><br>" + updateGarantiasCliente)));
                    tvUpdComprobantesCliente.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Comprobantes:</b><br>" + updateComprobantesCliente)));
                    tvUpdGarantiasAval.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Garant\u00edas:</b><br>" + updateGarantiasAval)));
                    tvUpdComprobantesAval.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Comprobantes:</b><br>" + updateComprobantesAval)));
                    if (ClientesAdapter.this.clientes.get(position).getLatitud() != null && ClientesAdapter.this.clientes.get(position).getLongitud() != null) {
                        tvUbicacionCliente.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n"));
                    } else {
                        tvUbicacionCliente.setVisibility(8);
                    }
                    tvNombreAval.setText((CharSequence)Html.fromHtml((String)("<b>Aval:</b> " + ClientesAdapter.this.clientes.get(position).getNombre_aval())));
                    tvDireccionAval.setText((CharSequence)Html.fromHtml((String)("<b>Direcci\u00f3n:</b> " + ClientesAdapter.this.clientes.get(position).getDireccion_aval())));
                    tvTelefonoAval.setText((CharSequence)Html.fromHtml((String)("<b>Tel\u00e9fono:</b> " + ClientesAdapter.this.clientes.get(position).getTelefono_aval())));
                    tvORAval.setText((CharSequence)Html.fromHtml((String)("<b>Otras referenc\u00edas:</b> " + ClientesAdapter.this.clientes.get(position).getOtras_referencias_aval())));
                    tvGarantiasAval.setText((CharSequence)Html.fromHtml((String)("<b>Garant\u00edas:</b> " + ClientesAdapter.this.clientes.get(position).getGarantias_aval())));
                    tvUbicacionCliente.setOnClickListener(view1 -> {
                        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)("google.navigation:q=" + ClientesAdapter.this.clientes.get(position).getLatitud() + "," + ClientesAdapter.this.clientes.get(position).getLongitud() + "&mode=d")));
                        i.setPackage("com.google.android.apps.maps");
                        ClientesAdapter.this.context.startActivity(i);
                    });
                    tvTelefonoCliente.setOnClickListener(view12 -> {
                        Intent intent = new Intent("android.intent.action.DIAL");
                        intent.setData(Uri.parse((String)("tel:" + ClientesAdapter.this.clientes.get(position).getTelefono())));
                        ClientesAdapter.this.context.startActivity(intent);
                    });
                    tvTelefonoAval.setOnClickListener(view13 -> {
                        Intent intent = new Intent("android.intent.action.DIAL");
                        intent.setData(Uri.parse((String)("tel:" + ClientesAdapter.this.clientes.get(position).getTelefono_aval())));
                        ClientesAdapter.this.context.startActivity(intent);
                    });
                    new MaterialAlertDialogBuilder(ClientesAdapter.this.context).setTitle((CharSequence)"").setView(dialogView).setPositiveButton((CharSequence)"Cerrar", (dialogInterface, i) -> {}).show();
                });
            }
        }
    }
}

