/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.os.Handler;
import android.os.SystemClock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConnectedThread
extends Thread {
    private final BluetoothSocket mmSocket;
    private final InputStream mmInStream;
    public final OutputStream mmOutStream;
    private final Handler mHandler;
    private final Context context;

    public ConnectedThread(BluetoothSocket socket, Handler handler, Context context) {
        this.mmSocket = socket;
        this.mHandler = handler;
        this.context = context;
        InputStream tmpIn = null;
        OutputStream tmpOut = null;
        try {
            tmpIn = socket.getInputStream();
            tmpOut = socket.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mmInStream = tmpIn;
        this.mmOutStream = tmpOut;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        try {
            while (true) {
                int bytes;
                if ((bytes = this.mmInStream.available()) == 0) {
                    continue;
                }
                buffer = new byte[1024];
                SystemClock.sleep((long)100L);
                bytes = this.mmInStream.available();
                bytes = this.mmInStream.read(buffer, 0, bytes);
                this.mHandler.obtainMessage(2, bytes, -1, (Object)buffer).sendToTarget();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void write(String input) {
        byte[] bytes = input.getBytes();
        try {
            this.mmOutStream.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancel() {
        try {
            this.mmSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

