/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.widget.Toast;
import com.android.volley.AuthFailureError;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorChecker {
    public static void showErrorMessage(String message, Context context) {
        new MaterialAlertDialogBuilder(context, 2131951627).setTitle((CharSequence)"Error").setMessage((CharSequence)message).setPositiveButton((CharSequence)"OK", (dialog, which) -> {}).show();
    }

    public static int checker(VolleyError error, Context context) {
        String message = null;
        int TYPE_ERROR = 0;
        if (error instanceof NetworkError) {
            Toast.makeText((Context)context, (CharSequence)"Te has desconectado de internet, revisa tu conexi\u00f3n", (int)1).show();
            TYPE_ERROR = 1;
        } else if (error instanceof ServerError) {
            message = "The server could not be found. Please try again after some time!!2";
            String statusCode = String.valueOf(error.networkResponse.statusCode);
            if (statusCode.equals("500")) {
                new MaterialAlertDialogBuilder(context).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"Error del servidor, comunicate con el equipo de soporte").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).show();
                TYPE_ERROR = 3;
            } else if (error.networkResponse.data != null) {
                try {
                    String body = new String(error.networkResponse.data, StandardCharsets.UTF_8);
                    JSONObject json = new JSONObject(body);
                    String mensaje = json.get("message").toString();
                    new MaterialAlertDialogBuilder(context).setTitle((CharSequence)"Aviso").setMessage((CharSequence)mensaje).setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                    TYPE_ERROR = 2;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } else if (error instanceof AuthFailureError) {
            message = "Cannot connect to Internet...Please check your connection!3";
            Toast.makeText((Context)context, (CharSequence)"Te has desconectado de internet, revisa tu conexi\u00f3n", (int)1).show();
            TYPE_ERROR = 4;
        } else if (error instanceof ParseError) {
            Log.e((String)"error", (String)error.getMessage());
            new MaterialAlertDialogBuilder(context).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"Error de c\u00f3digo, comunicate con el equipo de soporte").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                }
            }).show();
            TYPE_ERROR = 5;
        } else if (error instanceof NoConnectionError) {
            message = "Cannot connect to Internet...Please check your connection!5";
            Toast.makeText((Context)context, (CharSequence)"Te has desconectado de internet, revisa tu conexi\u00f3n", (int)1).show();
            TYPE_ERROR = 1;
        } else if (error instanceof TimeoutError) {
            message = "Connection TimeOut! Please check your internet connection.6";
            new MaterialAlertDialogBuilder(context).setTitle((CharSequence)"Aviso").setMessage((CharSequence)"Tiempo de espera excedido, vuelve a intentarlo").setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                }
            }).show();
            TYPE_ERROR = 6;
        }
        return TYPE_ERROR;
    }
}

