/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import java.math.BigInteger;
import java.util.regex.Pattern;

public class NumeroLetras {
    private final String[] UNIDADES = new String[]{"", "un ", "dos ", "tres ", "cuatro ", "cinco ", "seis ", "siete ", "ocho ", "nueve "};
    private final String[] DECENAS = new String[]{"diez ", "once ", "doce ", "trece ", "catorce ", "quince ", "dieciseis ", "diecisiete ", "dieciocho ", "diecinueve", "veinte ", "treinta ", "cuarenta ", "cincuenta ", "sesenta ", "setenta ", "ochenta ", "noventa "};
    private final String[] CENTENAS = new String[]{"", "ciento ", "doscientos ", "trecientos ", "cuatrocientos ", "quinientos ", "seiscientos ", "setecientos ", "ochocientos ", "novecientos "};

    public String Convertir(String numero, String etiquetaEnteroSingular, String etiquetaEnteroPlural, String etiquetaFlotanteSingular, String etiquetaFlotantePlural, String etiquetaConector, boolean mayusculas) {
        String literal = "";
        String parte_decimal = "";
        if ((numero = numero.replace(".", ",")).indexOf(",") == -1) {
            numero = numero + ",00";
        }
        if (Pattern.matches("\\d{1,12},\\d{1,2}", numero)) {
            BigInteger parteEntera;
            String d;
            String[] Num = numero.split(",");
            if (Num[1].length() == 1) {
                Num[1] = Num[1] + "0";
            }
            if ((d = this.getDecenas(Num[1])) != "") {
                if (etiquetaEnteroSingular != "") {
                    parte_decimal = parte_decimal + " ";
                }
                parte_decimal = Integer.parseInt(Num[1]) == 1 ? parte_decimal + etiquetaConector + " " + d + etiquetaFlotanteSingular : parte_decimal + etiquetaConector + " " + d + etiquetaFlotantePlural;
            }
            literal = (parteEntera = new BigInteger(Num[0])).compareTo(new BigInteger("0")) == 0 ? "cero " : (parteEntera.compareTo(new BigInteger("999999999")) == 1 ? this.getBillones(Num[0]) : (parteEntera.compareTo(new BigInteger("999999")) == 1 ? this.getMillones(Num[0]) : (parteEntera.compareTo(new BigInteger("999")) == 1 ? this.getMiles(Num[0]) : (parteEntera.compareTo(new BigInteger("99")) == 1 ? this.getCentenas(Num[0]) : (parteEntera.compareTo(new BigInteger("9")) == 1 ? this.getDecenas(Num[0]) : this.getUnidades(Num[0]))))));
            literal = parteEntera.compareTo(new BigInteger("1")) == 0 ? literal + etiquetaEnteroSingular : literal + etiquetaEnteroPlural;
            if (mayusculas) {
                return (literal + parte_decimal).toUpperCase();
            }
            return literal + parte_decimal;
        }
        literal = null;
        return null;
    }

    private String getUnidades(String numero) {
        String num = numero.substring(numero.length() - 1);
        return this.UNIDADES[Integer.parseInt(num)];
    }

    private String getDecenas(String num) {
        int n = Integer.parseInt(num);
        if (n < 10) {
            return this.getUnidades(num);
        }
        if (n > 19) {
            String u = this.getUnidades(num);
            if (u.equals("")) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8];
            }
            if (n == 21) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 22) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 23) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 24) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 25) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 26) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 27) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 28) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            if (n == 29) {
                return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8].substring(0, 5) + "i" + u;
            }
            return this.DECENAS[Integer.parseInt(num.substring(0, 1)) + 8] + "y " + u;
        }
        return this.DECENAS[n - 10];
    }

    private String getCentenas(String num) {
        if (Integer.parseInt(num) > 99) {
            if (Integer.parseInt(num) == 100) {
                return " cien ";
            }
            return this.CENTENAS[Integer.parseInt(num.substring(0, 1))] + this.getDecenas(num.substring(1));
        }
        return this.getDecenas(Integer.parseInt(num) + "");
    }

    private String getMiles(String numero) {
        String c = numero.substring(numero.length() - 3);
        String m = numero.substring(0, numero.length() - 3);
        String n = "";
        if (Integer.parseInt(m) > 0) {
            n = this.getCentenas(m);
            return n + "mil " + this.getCentenas(c);
        }
        return this.getCentenas(c);
    }

    private String getMillones(String numero) {
        String miles = numero.substring(numero.length() - 6);
        String millon = numero.substring(0, numero.length() - 6);
        String n = "";
        if (Integer.parseInt(millon) > 0) {
            n = Integer.parseInt(millon) == 1 ? this.getUnidades(millon) + "millon " : this.getCentenas(millon) + "millones ";
        }
        return n + this.getMiles(miles);
    }

    private String getBillones(String numero) {
        String miles = numero.substring(numero.length() - 9);
        String millon = numero.substring(0, numero.length() - 9);
        String n = "";
        n = Integer.parseInt(millon) == 1 ? this.getUnidades(millon) + "billon " : this.getCentenas(millon) + "billones ";
        return n + this.getMillones(miles);
    }
}

