/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PagosAdapter
extends RecyclerView.Adapter<PagosViewHolder> {
    Context context;
    ArrayList<Pago> pagos;
    private SharedPreferences sesion;
    Prestamo prestamo;
    public ArrayList<Pago> pagosSeleccionados = new ArrayList();

    public PagosAdapter(Context context, ArrayList<Pago> pagos, Prestamo prestamo) {
        this.context = context;
        this.pagos = pagos;
        this.prestamo = prestamo;
    }

    @NonNull
    public PagosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)this.context).inflate(2131493052, parent, false);
        return new PagosViewHolder(v);
    }

    public void onBindViewHolder(@NonNull PagosViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public int getItemCount() {
        return this.pagos.size();
    }

    public void clear() {
        this.pagos.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<Pago> list) {
        this.pagos = list;
        this.notifyDataSetChanged();
    }

    public class PagosViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvSemanaPago;
        TextView tvSemanalPago;
        TextView tvFechaPago;
        TextView tvFolioPago;
        TextView tvPendiente;
        ConstraintLayout pago_item_bg;
        Button btnPagar;
        Button btnPagarConMulta;
        Button btnNoPagar;
        String informacion;

        public PagosViewHolder(View itemView) {
            super(itemView);
            this.informacion = "";
            this.tvSemanaPago = (TextView)itemView.findViewById(2131297031);
            this.tvSemanalPago = (TextView)itemView.findViewById(2131297032);
            this.tvFechaPago = (TextView)itemView.findViewById(2131296637);
            this.tvFolioPago = (TextView)itemView.findViewById(2131296651);
            this.pago_item_bg = (ConstraintLayout)itemView.findViewById(2131296920);
            this.tvPendiente = (TextView)itemView.findViewById(2131296932);
        }

        public void imprimir(final int position) {
            String fecha = PagosAdapter.this.pagos.get(position).getFecha_pago().split("-")[2] + "/" + PagosAdapter.this.pagos.get(position).getFecha_pago().split("-")[1] + "/" + PagosAdapter.this.pagos.get(position).getFecha_pago().split("-")[0];
            String pagado = String.valueOf(Utils.convertirDouble(PagosAdapter.this.pagos.get(position).getCantidad_normal_pagada()) + Utils.convertirDouble(PagosAdapter.this.pagos.get(position).getCantidad_multa()));
            this.tvSemanaPago.setText((CharSequence)("Semana " + PagosAdapter.this.pagos.get(position).getSemana()));
            this.tvSemanalPago.setText((CharSequence)("$" + pagado + " / $" + PagosAdapter.this.pagos.get(position).getCantidad_esperada_pago()));
            this.tvFechaPago.setText((CharSequence)fecha);
            if (PagosAdapter.this.pagos.get(position).getFolio() != null && !PagosAdapter.this.pagos.get(position).getFolio().equals("0")) {
                this.tvSemanaPago.setText((CharSequence)("Semana " + PagosAdapter.this.pagos.get(position).getSemana() + " (" + PagosAdapter.this.pagos.get(position).getFolio() + ")"));
                this.pago_item_bg.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        new MaterialAlertDialogBuilder(PagosAdapter.this.context).setTitle((CharSequence)("Concepto de pago (" + PagosAdapter.this.pagos.get(position).getFolio() + ")")).setMessage((CharSequence)(PagosAdapter.this.pagos.get(position).getConcepto() + "\n \nPAGO REALIZADO: " + PagosAdapter.this.pagos.get(position).getFecha_pago_realizada())).setPositiveButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        }).show();
                        return false;
                    }
                });
            }
            if (!PagosAdapter.this.pagos.get(position).getCantidad_pendiente().equals("0.00")) {
                this.tvPendiente.setVisibility(0);
                this.tvPendiente.setText((CharSequence)("Pendiente: $" + PagosAdapter.this.pagos.get(position).getCantidad_pendiente()));
            } else {
                this.tvPendiente.setVisibility(8);
            }
            if (PagosAdapter.this.pagos.get(position).isSelected()) {
                this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
            }
            if (PagosAdapter.this.pagos.get(position).getStatus().equals("0") || PagosAdapter.this.pagos.get(position).getStatus().equals("-1") || PagosAdapter.this.pagos.get(position).getStatus().equals("1") && !PagosAdapter.this.pagos.get(position).getCantidad_pendiente().equals("0.00")) {
                if (PagosAdapter.this.pagos.get(position).isSelected()) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
                    this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                    this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                    this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                    this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("-1")) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131099717));
                    this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                    this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                    this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                    this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("1")) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100455));
                    this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                    this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                    this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                    this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                } else {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131099771));
                    this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                    this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                    this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                    this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                }
                this.pago_item_bg.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        if (PagosAdapter.this.pagos.get(position).isSelected()) {
                            PagosAdapter.this.pagos.get(position).setSelected(false);
                            if (PagosAdapter.this.pagos.get(position).getStatus().equals("-1")) {
                                PagosViewHolder.this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131099717));
                            } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("1")) {
                                PagosViewHolder.this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                                PagosViewHolder.this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100455));
                            } else {
                                PagosViewHolder.this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131099771));
                            }
                            PagosAdapter.this.pagosSeleccionados.remove(PagosAdapter.this.pagos.get(position));
                        } else {
                            PagosAdapter.this.pagos.get(position).setSelected(true);
                            PagosViewHolder.this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
                            PagosViewHolder.this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                            PagosViewHolder.this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                            PagosViewHolder.this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                            PagosViewHolder.this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                            PagosAdapter.this.pagosSeleccionados.add(PagosAdapter.this.pagos.get(position));
                        }
                        return false;
                    }
                });
            } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("1")) {
                if (PagosAdapter.this.pagos.get(position).isSelected()) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
                } else {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100455));
                }
                this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
            } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("2")) {
                if (PagosAdapter.this.pagos.get(position).isSelected()) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
                } else {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131099770));
                }
                this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
            } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("3")) {
                if (PagosAdapter.this.pagos.get(position).isSelected()) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
                } else {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100468));
                }
                this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
                this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131099681));
            } else if (PagosAdapter.this.pagos.get(position).getStatus().equals("4")) {
                if (PagosAdapter.this.pagos.get(position).isSelected()) {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100434));
                } else {
                    this.pago_item_bg.setBackgroundColor(PagosAdapter.this.context.getResources().getColor(2131100446));
                }
                this.tvSemanaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvSemanalPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvFechaPago.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
                this.tvPendiente.setTextColor(PagosAdapter.this.context.getResources().getColor(2131100470));
            }
        }

        private void pagar(String pago_id, String prestamo_id, String pago_recibido, String pago_multa, String concepto, String fecha_pago, String folio, String tipo_pago) {
            VolleyS vs = VolleyS.getInstance(PagosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"pagar");
                data.put("pago_id", (Object)pago_id);
                data.put("prestamo_id", (Object)prestamo_id);
                data.put("pago_recibido", (Object)pago_recibido);
                data.put("pago_multa", (Object)pago_multa);
                data.put("concepto", (Object)concepto);
                data.put("fecha_pago", (Object)fecha_pago);
                data.put("folio", (Object)folio);
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        Log.d((String)"dat", (String)data.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PagosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            requestQueue.add((Request)request);
        }

        private void noPagar(String pago_id, String pago_multa, String semana) {
            VolleyS vs = VolleyS.getInstance(PagosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"noPagar");
                data.put("pago_id", (Object)pago_id);
                data.put("pago_multa", (Object)pago_multa);
                data.put("semana", (Object)semana);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        String data = response.get("data").toString();
                        Toast.makeText((Context)PagosAdapter.this.context, (CharSequence)"Pago no recibido", (int)0).show();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PagosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            requestQueue.add((Request)request);
        }
    }
}

