/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentContainerView;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.PrestamoController;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Semana;
import com.example.sefinsa_app.ui.clientes.documentos.ClientesDocumentosFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesAvalesFotosFragment;
import com.example.sefinsa_app.ui.prestamos.PrestamosFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.example.sefinsa_app.utilities.NumeroLetras;
import com.example.sefinsa_app.utilities.PagosAdapter;
import com.example.sefinsa_app.utilities.ProgressDialogFragment;
import com.example.sefinsa_app.utilities.ResponseMe;
import com.example.sefinsa_app.utilities.RetrofitInterface;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.nex3z.flowlayout.FlowLayout;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class PrestamosAdapter
extends RecyclerView.Adapter<PrestamosViewHolder> {
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private Uri image_uri;
    Context context;
    ArrayList<Prestamo> prestamos;
    ArrayList<Cliente> clientes;
    ArrayList<String> avales;
    ArrayList<String> nombresAvales;
    public ArrayList<Prestamo> prestamosSeleccionados = new ArrayList();
    public ArrayList<Prestamo> prestamosPagar = new ArrayList();
    public ArrayList<Prestamo> prestamosPagarConMulta = new ArrayList();
    public ArrayList<Prestamo> prestamosNoPagar = new ArrayList();
    public ArrayList<Prestamo> prestamosAdelantar = new ArrayList();
    private SharedPreferences sesion;
    public boolean isSelectMode = true;
    public boolean seleccionPagar = false;
    public boolean seleccionPagarConMulta = false;
    public boolean seleccionNoPagar = false;
    public boolean seleccionAdelantar = false;
    String fecha_pago;
    String pago_semanal;
    public ArrayList<Semana> semanasGeneradas;
    public ArrayList<Semana> semanasPagadasList;
    public ArrayList<Semana> semanasPagadasConMultaList;
    public ArrayList<Semana> semanasNoPagadasList;
    public ArrayList<Semana> semanasPendientesList;
    public ArrayList<Semana> semanasAdelantadasList;
    public Button btnCamGarantiasRetiradas;
    public Button btnGuardarGarantiasRetiradas;
    public FlowLayout contenedorSemanas;
    String path;
    private int banderaGarantiasRetiradas;
    private RecyclerView recyclerViewPagos;
    private ShimmerFrameLayout shimmer;
    private PagosAdapter pagosAdapter;
    private LinearLayoutManager linearLayoutManager;
    private ArrayList<Pago> pagos;
    private ArrayList<Pago> pagos2;
    public ArrayList<String> pathsGarantiasRetiradas;
    public List<MultipartBody.Part> archivosGeneral;
    private PrestamosFragment fragment;
    private ArrayAdapter<Cliente> clientesAdapter;
    private ArrayAdapter<Aval> avalesAdapter;
    private AutoCompleteTextView avalesAutoCompleteTextView;
    private String aval_id = "";
    private int prestamo_id = 0;
    private int previousLengthCliente;
    private int previousLengthAval;
    private boolean backSpaceCliente;
    private boolean backSpaceAval;
    private TextInputLayout tlNombreAval;
    private Bundle bundle;
    private AvalController avalController;
    public int idgarantia = 0;
    private Button btnToggleVisibility;
    private boolean isVisible = false;
    public int cantidadTotalGarantias = 0;
    private ProgressDialogFragment progressDialogFragment;
    private List<Prestamo> prestamosList;

    public PrestamosAdapter(Context context, PrestamosFragment fragment, ArrayList<Prestamo> prestamos, ArrayList<MultipartBody.Part> archivosGeneral, ArrayList<String> pathsGarantiasRetiradas, ArrayList<Cliente> clientes, Bundle bundle) {
        this.context = context;
        this.fragment = fragment;
        this.prestamos = prestamos;
        this.archivosGeneral = archivosGeneral;
        this.pathsGarantiasRetiradas = pathsGarantiasRetiradas;
        this.clientes = clientes;
        this.bundle = bundle;
        this.setHasStableIds(true);
    }

    public void updateData(List<Prestamo> newPrestamos) {
        this.prestamosList.clear();
        this.prestamosList.addAll(newPrestamos);
        this.notifyDataSetChanged();
    }

    public void updateData(ArrayList<Prestamo> nuevosPrestamos) {
        this.prestamos.addAll(nuevosPrestamos);
        this.notifyDataSetChanged();
    }

    private Bundle getArguments() {
        return this.bundle;
    }

    public void ClientesAdapter(Context context, ArrayList<Cliente> clientes) {
        this.context = context;
        this.clientes = clientes;
    }

    public void addFilesAndPaths(ArrayList<MultipartBody.Part> nuevosArchivos, ArrayList<String> nuevasRutas) {
        this.archivosGeneral.addAll(nuevosArchivos);
        this.pathsGarantiasRetiradas.addAll(nuevasRutas);
    }

    public void updateButtonText() {
        if (this.btnCamGarantiasRetiradas != null) {
            this.btnCamGarantiasRetiradas.setText((CharSequence)("Garant\u00edas retiradas (" + this.pathsGarantiasRetiradas.size() + ")"));
        }
    }

    public void setListaFiltrada(ArrayList<Prestamo> filteredListPrestamos) {
        this.prestamos = filteredListPrestamos;
        this.notifyDataSetChanged();
    }

    @NonNull
    public PrestamosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.sesion = this.context.getSharedPreferences("sesion", 0);
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(2131493057, parent, false);
        return new PrestamosViewHolder(v);
    }

    public void onBindViewHolder(@NonNull PrestamosViewHolder holder, int position) {
        if (holder != null) {
            holder.imprimir(position);
        } else {
            Log.e((String)"PrestamosAdapter", (String)"Error al intentar acceder al holder.");
        }
    }

    public int getItemViewType(int position) {
        return position;
    }

    public int getItemCount() {
        return this.prestamos.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public void clear() {
        this.prestamos.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<Prestamo> list) {
        this.prestamos = list;
        this.notifyDataSetChanged();
    }

    public PrestamosAdapter(Context context) {
        this.context = context;
    }

    public List<Button> getAllButtons(ViewGroup layout2) {
        ArrayList<Button> btn = new ArrayList<Button>();
        for (int i = 0; i < layout2.getChildCount(); ++i) {
            View v = layout2.getChildAt(i);
            if (!(v instanceof Button)) continue;
            btn.add((Button)v);
        }
        return btn;
    }

    public void subirGarantiasRetiradas(String fecha_pago2, String prestamo, final ArrayList<String> pathsGarantiasRetiradas, final ArrayList<MultipartBody.Part> archivosGeneral, String tldescripcion) {
        HashSet<String> setPaths = new HashSet<String>(pathsGarantiasRetiradas);
        pathsGarantiasRetiradas.clear();
        pathsGarantiasRetiradas.addAll(setPaths);
        HashSet<MultipartBody.Part> setArchivos = new HashSet<MultipartBody.Part>(archivosGeneral);
        archivosGeneral.clear();
        archivosGeneral.addAll(setArchivos);
        final ProgressDialog dialog = new ProgressDialog(this.context, 2131951627);
        dialog.setMessage((CharSequence)"Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(API.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        Log.d((String)"DEBUG", (String)("La lista pathsGarantiasRetiradas FORM antes de OK : " + archivosGeneral + "/" + pathsGarantiasRetiradas));
        if (pathsGarantiasRetiradas == null || pathsGarantiasRetiradas.isEmpty()) {
            Log.d((String)"DEBUG", (String)"La lista pathsGarantiasRetiradas es null");
            dialog.cancel();
        } else if (pathsGarantiasRetiradas.size() > 0) {
            Log.d((String)"DEBUG", (String)("La lista pathsGarantiasRetiradas Tama\u00f1o: " + pathsGarantiasRetiradas.size()));
            RetrofitInterface retrofitInterface = (RetrofitInterface)retrofit.create(RetrofitInterface.class);
            RequestBody func = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"subirFotosGarantiasRetiradas");
            RequestBody cliente_id = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)prestamo);
            RequestBody empleado_id = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)this.sesion.getString("id", "0"));
            RequestBody garantias_retiradas_cliente = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)(pathsGarantiasRetiradas.size() + ""));
            RequestBody fecha_pago = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)fecha_pago2);
            RequestBody descripcion = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)tldescripcion);
            Log.d((String)"DEBUG", (String)("La lista pathsGarantiasRetiradas FORM OK: " + prestamo + "/" + this.sesion.getString("id", "0") + "/" + pathsGarantiasRetiradas + "/" + fecha_pago2));
            Call<ResponseMe> call = retrofitInterface.subirFotosGarantiasRetiradas(archivosGeneral, func, cliente_id, garantias_retiradas_cliente, fecha_pago, empleado_id, descripcion);
            call.enqueue((Callback)new Callback<ResponseMe>(){

                public void onResponse(Call<ResponseMe> call, Response<ResponseMe> response) {
                    dialog.cancel();
                    if (response.isSuccessful()) {
                        Log.d((String)"response", (String)((ResponseMe)response.body()).getMessage());
                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Se han subido las im\u00e1genes de las garant\u00edas", (int)1).show();
                        pathsGarantiasRetiradas.clear();
                        archivosGeneral.clear();
                        dialog.cancel();
                    } else {
                        try {
                            JSONObject jObjError = new JSONObject(response.errorBody().string());
                            new MaterialAlertDialogBuilder(PrestamosAdapter.this.context).setTitle((CharSequence)"Aviso").setMessage((CharSequence)jObjError.getString("message")).setPositiveButton((CharSequence)"Ok", (dialogInterface, i) -> {}).show();
                        }
                        catch (Exception e) {
                            Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)e.getMessage(), (int)1).show();
                        }
                    }
                }

                public void onFailure(Call<ResponseMe> call, Throwable t) {
                    dialog.cancel();
                    Log.d((String)"TAG", (String)("onFailure: " + t.getLocalizedMessage()));
                }
            });
        }
    }

    public class PrestamosViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvTarjetonPrestamo;
        TextView tvClientePrestamo;
        TextView tvFechaPrestamo;
        TextView tvMontoPrestamo;
        TextView tvSemanalPrestamo;
        TextView tvModalidadPrestamo;
        TextView tvRutaPoblacionPrestamo;
        TextView tvCantidadPrestamosSeleccionados;
        TextView tvSeleccion;
        ConstraintLayout prestamo_item_bg;
        Button btnVerInformacion;
        Button btnVerPagos;
        Button btnCambiarAval;
        Button btnGuardarCambioAval;
        LinearLayoutCompat linearLayout;
        RecyclerView rvPrestamos;
        Button btnPagar;
        Button btnPagarConMulta;
        Button btnNoPagar;
        Button btnCancelar;
        Button btnAdelantar;
        String informacion;

        public PrestamosViewHolder(View itemView) {
            super(itemView);
            this.informacion = "";
            this.tvTarjetonPrestamo = (TextView)itemView.findViewById(2131297122);
            this.tvClientePrestamo = (TextView)itemView.findViewById(2131296493);
            this.tvMontoPrestamo = (TextView)itemView.findViewById(2131296815);
            this.btnVerInformacion = (Button)itemView.findViewById(2131296464);
            this.btnVerPagos = (Button)itemView.findViewById(2131296468);
            this.btnCambiarAval = (Button)itemView.findViewById(2131296411);
            this.linearLayout = (LinearLayoutCompat)((Activity)PrestamosAdapter.this.context).findViewById(2131296380);
            this.rvPrestamos = (RecyclerView)((Activity)PrestamosAdapter.this.context).findViewById(2131296984);
            this.tvCantidadPrestamosSeleccionados = (TextView)((Activity)PrestamosAdapter.this.context).findViewById(2131297271);
            this.btnPagar = (Button)((Activity)PrestamosAdapter.this.context).findViewById(2131296443);
            this.btnPagarConMulta = (Button)((Activity)PrestamosAdapter.this.context).findViewById(2131296444);
            this.btnNoPagar = (Button)((Activity)PrestamosAdapter.this.context).findViewById(2131296442);
            this.btnAdelantar = (Button)((Activity)PrestamosAdapter.this.context).findViewById(2131296390);
            this.btnCancelar = (Button)((Activity)PrestamosAdapter.this.context).findViewById(2131296412);
            this.tvSeleccion = (TextView)((Activity)PrestamosAdapter.this.context).findViewById(2131297327);
            this.prestamo_item_bg = (ConstraintLayout)itemView.findViewById(2131296941);
            PrestamosAdapter.this.btnCamGarantiasRetiradas = (Button)itemView.findViewById(2131296398);
        }

        private String formatFecha(String fecha) {
            if (fecha == null) {
                return "...";
            }
            SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat desiredFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            try {
                Date date = originalFormat.parse(fecha);
                return desiredFormat.format(date);
            }
            catch (ParseException | java.text.ParseException e) {
                e.printStackTrace();
                return "...";
            }
        }

        public void cambio() {
            AlertDialog.Builder confirmDialog = new AlertDialog.Builder(PrestamosAdapter.this.context);
            confirmDialog.setTitle((CharSequence)"Confirmaci\u00f3n");
            confirmDialog.setMessage((CharSequence)"\u00bfEst\u00e1 seguro de cambiar el aval?");
            confirmDialog.setPositiveButton((CharSequence)"S\u00ed", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    DatabaseHelper dbHelper = new DatabaseHelper(PrestamosAdapter.this.context);
                    SQLiteDatabase db = dbHelper.getWritableDatabase();
                    ContentValues values = new ContentValues();
                    values.put("aval_id", PrestamosAdapter.this.aval_id);
                    Log.d((String)"DEBUG", (String)("ID AVAL para actualizar...............................: " + PrestamosAdapter.this.aval_id));
                    long timestamp = System.currentTimeMillis();
                    Date date = new Date(timestamp);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
                    String formattedDate = sdf.format(date);
                    values.put("updated_at", formattedDate);
                    int rowsAffected = db.update("prestamos", values, "id = ?", new String[]{String.valueOf(PrestamosAdapter.this.prestamo_id)});
                    if (rowsAffected > 0) {
                        PrestamosViewHolder.this.CambiarAval(String.valueOf(PrestamosAdapter.this.prestamo_id), PrestamosAdapter.this.aval_id);
                        Log.d((String)"DEBUG", (String)("Aval actualizado exitosamente en el pr\u00e9stamo con ID: " + PrestamosAdapter.this.prestamo_id));
                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Aval actualizado", (int)1).show();
                    } else {
                        Log.d((String)"DEBUG", (String)("No se pudo actualizar el aval en el pr\u00e9stamo con ID: " + PrestamosAdapter.this.prestamo_id));
                    }
                    db.close();
                    PrestamosViewHolder.this.cargarPrestamosConsulta();
                }
            });
            confirmDialog.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss();
                }
            });
            confirmDialog.show();
        }

        @SuppressLint(value={"StaticFieldLeak"})
        public void imprimir(final int position) {
            String nombre_aval = PrestamosAdapter.this.prestamos.get(position).getNombre_aval();
            this.tvTarjetonPrestamo.setText((CharSequence)PrestamosAdapter.this.prestamos.get(position).getNumero_tarjeton());
            this.tvClientePrestamo.setText((CharSequence)Html.fromHtml((String)(PrestamosAdapter.this.prestamos.get(position).getNombre_completo() + "<br/>AVAL: " + nombre_aval + "<br/>GRUPO: " + PrestamosAdapter.this.prestamos.get(position).getGrupo_poblacion())));
            this.tvMontoPrestamo.setText((CharSequence)("$" + PrestamosAdapter.this.prestamos.get(position).getMonto_prestado()));
            this.informacion = "<p> <b>Cliente:</b> " + PrestamosAdapter.this.prestamos.get(position).getNombre_completo() + " <br><br> <b>Direcci\u00f3n:</b> " + PrestamosAdapter.this.prestamos.get(position).getDireccion_cliente() + " <br><br> <b>Tel\u00e9fono:</b> " + PrestamosAdapter.this.prestamos.get(position).getTelefono_cliente() + " <br><br> <b>Garant\u00edas:</b> " + PrestamosAdapter.this.prestamos.get(position).getGarantias() + " <p> <br> <p> <b>Aval:</b> " + PrestamosAdapter.this.prestamos.get(position).getNombre_aval() + " <br><br> <b>Direcci\u00f3n:</b> " + PrestamosAdapter.this.prestamos.get(position).getDireccion_aval() + " <br><br> <b>Tel\u00e9fono:</b> " + PrestamosAdapter.this.prestamos.get(position).getTelefono_aval() + " <br><br> <b>Otras referenc\u00edas:</b> " + PrestamosAdapter.this.prestamos.get(position).getOr_aval() + " <br><br> <b>Garant\u00edas:</b> " + PrestamosAdapter.this.prestamos.get(position).getGarantias_aval() + "</p>";
            this.prestamo_item_bg.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    if (PrestamosAdapter.this.seleccionPagar) {
                        if (PrestamosAdapter.this.prestamos.get(position).isSelectedPagar()) {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedPagar(false);
                            if (!PrestamosAdapter.this.prestamos.get(position).getEs_semana_14().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0") || !PrestamosAdapter.this.prestamos.get(position).getEs_semana_19().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0")) {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            } else {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099771));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            }
                            PrestamosAdapter.this.prestamosPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                        } else {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedPagar(true);
                            PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100455));
                            PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosAdapter.this.prestamosPagar.add(PrestamosAdapter.this.prestamos.get(position));
                            if (PrestamosAdapter.this.prestamosNoPagar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosNoPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedNoPagar(false);
                            }
                            if (PrestamosAdapter.this.prestamosPagarConMulta.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosPagarConMulta.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedPagarConMulta(false);
                            }
                            if (PrestamosAdapter.this.prestamosAdelantar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosAdelantar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedAdelantar(false);
                            }
                        }
                    } else if (PrestamosAdapter.this.seleccionPagarConMulta) {
                        if (PrestamosAdapter.this.prestamos.get(position).isSelectedPagarConMulta()) {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedPagarConMulta(false);
                            if (!PrestamosAdapter.this.prestamos.get(position).getEs_semana_14().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0") || !PrestamosAdapter.this.prestamos.get(position).getEs_semana_19().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0")) {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            } else {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099771));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            }
                            PrestamosAdapter.this.prestamosPagarConMulta.remove(PrestamosAdapter.this.prestamos.get(position));
                        } else {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedPagarConMulta(true);
                            PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100468));
                            PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            PrestamosAdapter.this.prestamosPagarConMulta.add(PrestamosAdapter.this.prestamos.get(position));
                            if (PrestamosAdapter.this.prestamosPagar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedPagar(false);
                            }
                            if (PrestamosAdapter.this.prestamosNoPagar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosNoPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedNoPagar(false);
                            }
                            if (PrestamosAdapter.this.prestamosAdelantar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosAdelantar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedAdelantar(false);
                            }
                        }
                    } else if (PrestamosAdapter.this.seleccionNoPagar) {
                        if (PrestamosAdapter.this.prestamos.get(position).isSelectedNoPagar()) {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedNoPagar(false);
                            if (!PrestamosAdapter.this.prestamos.get(position).getEs_semana_14().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0") || !PrestamosAdapter.this.prestamos.get(position).getEs_semana_19().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0")) {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            } else {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099771));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            }
                            PrestamosAdapter.this.prestamosNoPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                        } else {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedNoPagar(true);
                            PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099717));
                            PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosAdapter.this.prestamosNoPagar.add(PrestamosAdapter.this.prestamos.get(position));
                            if (PrestamosAdapter.this.prestamosPagar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedPagar(false);
                            }
                            if (PrestamosAdapter.this.prestamosPagarConMulta.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosPagarConMulta.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedPagarConMulta(false);
                            }
                            if (PrestamosAdapter.this.prestamosAdelantar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosAdelantar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedAdelantar(false);
                            }
                        }
                    } else if (PrestamosAdapter.this.seleccionAdelantar) {
                        if (PrestamosAdapter.this.prestamos.get(position).isSelectedAdelantar()) {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedAdelantar(false);
                            if (!PrestamosAdapter.this.prestamos.get(position).getEs_semana_14().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0") || !PrestamosAdapter.this.prestamos.get(position).getEs_semana_19().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_multas().equals("0") && PrestamosAdapter.this.prestamos.get(position).getTiene_folios().equals("0")) {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            } else {
                                PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099771));
                                PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                                PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                            }
                            PrestamosAdapter.this.prestamosAdelantar.remove(PrestamosAdapter.this.prestamos.get(position));
                        } else {
                            PrestamosAdapter.this.prestamos.get(position).setSelectedAdelantar(true);
                            PrestamosViewHolder.this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100446));
                            PrestamosViewHolder.this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosViewHolder.this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosViewHolder.this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                            PrestamosAdapter.this.prestamosAdelantar.add(PrestamosAdapter.this.prestamos.get(position));
                            if (PrestamosAdapter.this.prestamosPagar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedPagar(false);
                            }
                            if (PrestamosAdapter.this.prestamosPagarConMulta.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosPagarConMulta.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedPagarConMulta(false);
                            }
                            if (PrestamosAdapter.this.prestamosNoPagar.contains(PrestamosAdapter.this.prestamos.get(position))) {
                                PrestamosAdapter.this.prestamosNoPagar.remove(PrestamosAdapter.this.prestamos.get(position));
                                PrestamosAdapter.this.prestamos.get(position).setSelectedNoPagar(false);
                            }
                        }
                    }
                    if (PrestamosAdapter.this.prestamosPagar.size() != 0) {
                        PrestamosViewHolder.this.btnPagar.setText((CharSequence)(" (" + PrestamosAdapter.this.prestamosPagar.size() + ")"));
                    } else {
                        PrestamosViewHolder.this.btnPagar.setText((CharSequence)"");
                    }
                    if (PrestamosAdapter.this.prestamosAdelantar.size() != 0) {
                        PrestamosViewHolder.this.btnAdelantar.setText((CharSequence)(" (" + PrestamosAdapter.this.prestamosAdelantar.size() + ")"));
                    } else {
                        PrestamosViewHolder.this.btnAdelantar.setText((CharSequence)"");
                    }
                    if (PrestamosAdapter.this.prestamosPagarConMulta.size() != 0) {
                        PrestamosViewHolder.this.btnPagarConMulta.setText((CharSequence)("M (" + PrestamosAdapter.this.prestamosPagarConMulta.size() + ")"));
                    } else {
                        PrestamosViewHolder.this.btnPagarConMulta.setText((CharSequence)"M");
                    }
                    if (PrestamosAdapter.this.prestamosNoPagar.size() != 0) {
                        PrestamosViewHolder.this.btnNoPagar.setText((CharSequence)(" (" + PrestamosAdapter.this.prestamosNoPagar.size() + ")"));
                    } else {
                        PrestamosViewHolder.this.btnNoPagar.setText((CharSequence)"");
                    }
                    PrestamosViewHolder.this.btnCancelar.setText((CharSequence)("Cancelar (" + (PrestamosAdapter.this.prestamosPagar.size() + PrestamosAdapter.this.prestamosPagarConMulta.size() + PrestamosAdapter.this.prestamosNoPagar.size()) + ")"));
                    return false;
                }
            });
            this.btnPagar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PrestamosAdapter.this.seleccionPagar = true;
                    PrestamosAdapter.this.seleccionAdelantar = false;
                    PrestamosAdapter.this.seleccionPagarConMulta = false;
                    PrestamosAdapter.this.seleccionNoPagar = false;
                    PrestamosViewHolder.this.tvSeleccion.setText((CharSequence)"Selecci\u00f3n: Pagar");
                }
            });
            this.btnAdelantar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PrestamosAdapter.this.seleccionAdelantar = true;
                    PrestamosAdapter.this.seleccionPagar = false;
                    PrestamosAdapter.this.seleccionPagarConMulta = false;
                    PrestamosAdapter.this.seleccionNoPagar = false;
                    PrestamosViewHolder.this.tvSeleccion.setText((CharSequence)"Selecci\u00f3n: Adelantar Pago");
                }
            });
            this.btnPagarConMulta.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PrestamosAdapter.this.seleccionPagar = false;
                    PrestamosAdapter.this.seleccionAdelantar = false;
                    PrestamosAdapter.this.seleccionPagarConMulta = true;
                    PrestamosAdapter.this.seleccionNoPagar = false;
                    PrestamosViewHolder.this.tvSeleccion.setText((CharSequence)"Selecci\u00f3n: Pagar con multa");
                }
            });
            this.btnNoPagar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PrestamosAdapter.this.seleccionPagar = false;
                    PrestamosAdapter.this.seleccionAdelantar = false;
                    PrestamosAdapter.this.seleccionPagarConMulta = false;
                    PrestamosAdapter.this.seleccionNoPagar = true;
                    PrestamosViewHolder.this.tvSeleccion.setText((CharSequence)"Selecci\u00f3n: No pagar");
                }
            });
            if (PrestamosAdapter.this.prestamos.get(position).isSelectedPagar()) {
                this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100455));
                this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
            } else if (PrestamosAdapter.this.prestamos.get(position).isSelectedPagarConMulta()) {
                this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100468));
                this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
            } else if (PrestamosAdapter.this.prestamos.get(position).isSelectedNoPagar()) {
                this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099717));
                this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
            } else if (PrestamosAdapter.this.prestamos.get(position).isSelectedAdelantar()) {
                this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100446));
                this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
            } else {
                String esSemana14 = PrestamosAdapter.this.prestamos.get(position).getEs_semana_14();
                String tienePendientes = PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes();
                String tieneMultas = PrestamosAdapter.this.prestamos.get(position).getTiene_multas();
                String tieneFolios = PrestamosAdapter.this.prestamos.get(position).getTiene_folios();
                if (esSemana14 != null && !esSemana14.equals("0") && tienePendientes != null && tienePendientes.equals("0") && tieneMultas != null && tieneMultas.equals("0") && tieneFolios != null && tieneFolios.equals("0") || PrestamosAdapter.this.prestamos.get(position).getEs_semana_19() != null && !PrestamosAdapter.this.prestamos.get(position).getEs_semana_19().equals("0") && tienePendientes != null && tienePendientes.equals("0") && tieneMultas != null && tieneMultas.equals("0") && tieneFolios != null && tieneFolios.equals("0")) {
                    this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                    this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                    this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                    this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                } else {
                    this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099771));
                    this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                    this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                    this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131099681));
                }
            }
            this.btnCambiarAval.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ProgressDialog progressDialog = new ProgressDialog(PrestamosAdapter.this.context);
                    progressDialog.setMessage((CharSequence)"Cargando avales, por favor espere...");
                    progressDialog.setCancelable(false);
                    progressDialog.show();
                    PrestamosAdapter.this.prestamo_id = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getId());
                    Log.d((String)"DEBUG", (String)("ID PRESTAMO para actualizar...............................: " + PrestamosAdapter.this.prestamo_id));
                    View dialogView = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492928, null);
                    PrestamosAdapter.this.tlNombreAval = (TextInputLayout)dialogView.findViewById(2131297201);
                    PrestamosAdapter.this.avalesAutoCompleteTextView = (AutoCompleteTextView)dialogView.findViewById(2131296282);
                    if (PrestamosAdapter.this.avales == null) {
                        PrestamosAdapter.this.avales = new ArrayList();
                    }
                    if (PrestamosAdapter.this.nombresAvales == null) {
                        PrestamosAdapter.this.nombresAvales = new ArrayList();
                    }
                    if (PrestamosAdapter.this.avales.isEmpty() || PrestamosAdapter.this.nombresAvales.isEmpty()) {
                        this.getAvales(progressDialog, dialogView);
                    } else {
                        this.showChangeAvalDialog(progressDialog, dialogView);
                        progressDialog.dismiss();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void getAvales(ProgressDialog progressDialog, View dialogView) {
                    DatabaseHelper dbHelper = new DatabaseHelper(PrestamosAdapter.this.context);
                    SQLiteDatabase db = dbHelper.getReadableDatabase();
                    Cursor cursor = null;
                    try {
                        cursor = db.rawQuery("SELECT id, nombre_completo FROM avales", null);
                        PrestamosAdapter.this.avales.clear();
                        PrestamosAdapter.this.nombresAvales.clear();
                        if (cursor != null && cursor.moveToFirst()) {
                            do {
                                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                                String nombreCompleto = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                                PrestamosAdapter.this.avales.add(id2);
                                PrestamosAdapter.this.nombresAvales.add(nombreCompleto);
                            } while (cursor.moveToNext());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Error al obtener los avales", (int)0).show();
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                        db.close();
                    }
                    progressDialog.dismiss();
                    this.showChangeAvalDialog(progressDialog, dialogView);
                }

                private void showChangeAvalDialog(ProgressDialog progressDialog, View dialogView) {
                    ArrayAdapter avalesAdapter = new ArrayAdapter(PrestamosAdapter.this.context, 17367050, PrestamosAdapter.this.nombresAvales);
                    PrestamosAdapter.this.avalesAutoCompleteTextView.setThreshold(1);
                    PrestamosAdapter.this.avalesAutoCompleteTextView.setAdapter((ListAdapter)avalesAdapter);
                    AlertDialog.Builder builder = new AlertDialog.Builder(PrestamosAdapter.this.context);
                    builder.setView(dialogView);
                    final AlertDialog dialog = builder.create();
                    Button btnCambiarAvalDialog = (Button)dialogView.findViewById(2131296433);
                    btnCambiarAvalDialog.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (!PrestamosAdapter.this.tlNombreAval.getEditText().getText().toString().isEmpty() || PrestamosAdapter.this.tlNombreAval.getEditText().getText() != null) {
                                AvalController ac = new AvalController(PrestamosAdapter.this.context);
                                String avalId = ac.getAvalByNombre(PrestamosAdapter.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                                if (!avalId.isEmpty() || avalId != null) {
                                    ClienteController cc = new ClienteController(PrestamosAdapter.this.context);
                                    String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(PrestamosAdapter.this.tlNombreAval.getEditText().getText().toString().toUpperCase());
                                    if (Objects.equals(prestaNombre, "1")) {
                                        AlertDialog.Builder b = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                        b.setTitle((CharSequence)"Aviso");
                                        b.setMessage((CharSequence)"\u00a1Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                        b.setPositiveButton((CharSequence)"Aceptar", null);
                                        AlertDialog dialog2 = b.create();
                                        dialog2.show();
                                    } else {
                                        PrestamosViewHolder.this.cambio();
                                    }
                                } else {
                                    PrestamosViewHolder.this.cambio();
                                }
                            } else {
                                PrestamosViewHolder.this.cambio();
                            }
                            dialog.dismiss();
                        }
                    });
                    PrestamosAdapter.this.avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                            PrestamosAdapter.this.aval_id = PrestamosAdapter.this.avales.get(i);
                            Log.d((String)"DEBUG", (String)("El aval_id es: " + PrestamosAdapter.this.aval_id));
                        }
                    });
                    dialog.show();
                }

                private Bundle getArguments() {
                    return PrestamosAdapter.this.bundle;
                }
            });
            this.btnVerInformacion.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    View dialogView = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492936, null, false);
                    TextView tvSemanasPendientes = (TextView)dialogView.findViewById(2131297331);
                    TextView tvSemanasAtraso = (TextView)dialogView.findViewById(2131297330);
                    PrestamosAdapter.this.pagos2 = new ArrayList();
                    PrestamosAdapter.this.pagosAdapter = new PagosAdapter(PrestamosAdapter.this.context, PrestamosAdapter.this.pagos2, PrestamosAdapter.this.prestamos.get(position));
                    PrestamosViewHolder.this.getInfo(PrestamosAdapter.this.prestamos.get(position).getId(), position, tvSemanasPendientes, tvSemanasAtraso);
                    TextView tvNombreCliente = (TextView)dialogView.findViewById(2131297313);
                    TextView tvDireccionCliente = (TextView)dialogView.findViewById(2131297283);
                    TextView tvTelefonoCliente = (TextView)dialogView.findViewById(2131297334);
                    TextView tvUbicacionCliente = (TextView)dialogView.findViewById(2131297339);
                    final TextView tvMapaCliente = (TextView)dialogView.findViewById(2131297303);
                    TextView tvColocadoraCliente = (TextView)dialogView.findViewById(2131297274);
                    LinearLayoutCompat llColocadoraCliente = (LinearLayoutCompat)dialogView.findViewById(2131296767);
                    TextView tvPoblacionCliente = (TextView)dialogView.findViewById(2131297320);
                    LinearLayoutCompat llPoblacionCliente = (LinearLayoutCompat)dialogView.findViewById(2131296768);
                    TextView tvGarantiasCliente = (TextView)dialogView.findViewById(2131297295);
                    final TextView tvMapaAval = (TextView)dialogView.findViewById(2131297302);
                    TextView tvNombreAval = (TextView)dialogView.findViewById(2131297311);
                    TextView tvDireccionAval = (TextView)dialogView.findViewById(2131297281);
                    TextView tvTelefonoAval = (TextView)dialogView.findViewById(2131297332);
                    TextView tvORAval = (TextView)dialogView.findViewById(2131297314);
                    TextView tvGarantiasAval = (TextView)dialogView.findViewById(2131297293);
                    TextView tvUpdGarantiasCliente = (TextView)dialogView.findViewById(2131297345);
                    TextView tvUpdComprobantesCliente = (TextView)dialogView.findViewById(2131297342);
                    TextView tvUpdGarantiasAval = (TextView)dialogView.findViewById(2131297343);
                    TextView tvUpdComprobantesAval = (TextView)dialogView.findViewById(2131297340);
                    String updateGarantiasCliente = PrestamosAdapter.this.prestamos.get(position).getUpdate_garantias_cliente();
                    String updateComprobantesCliente = PrestamosAdapter.this.prestamos.get(position).getUpdate_comprobantes_cliente();
                    updateGarantiasCliente = updateGarantiasCliente != null ? updateGarantiasCliente : "...";
                    updateComprobantesCliente = updateComprobantesCliente != null ? updateComprobantesCliente : "...";
                    String updateGarantiasAval = PrestamosAdapter.this.prestamos.get(position).getUpdate_garantias_aval();
                    String updateComprobantesAval = PrestamosAdapter.this.prestamos.get(position).getUpdate_comprobantes_aval();
                    updateComprobantesAval = updateComprobantesAval != null ? updateComprobantesAval : "...";
                    updateGarantiasAval = updateGarantiasAval != null ? updateGarantiasAval : "...";
                    updateGarantiasCliente = PrestamosViewHolder.this.formatFecha(updateGarantiasCliente);
                    updateComprobantesCliente = PrestamosViewHolder.this.formatFecha(updateComprobantesCliente);
                    updateGarantiasAval = PrestamosViewHolder.this.formatFecha(updateGarantiasAval);
                    updateComprobantesAval = PrestamosViewHolder.this.formatFecha(updateComprobantesAval);
                    tvUpdGarantiasCliente.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Garant\u00edas:</b><br>" + updateGarantiasCliente)));
                    tvUpdComprobantesCliente.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Comprobantes:</b><br>" + updateComprobantesCliente)));
                    tvUpdGarantiasAval.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Garant\u00edas:</b><br>" + updateGarantiasAval)));
                    tvUpdComprobantesAval.setText((CharSequence)Html.fromHtml((String)("<b>\u00daltimas fotos Comprobantes:</b><br>" + updateComprobantesAval)));
                    tvColocadoraCliente.setText((CharSequence)Html.fromHtml((String)("<b>Colocadora:</b> " + PrestamosAdapter.this.prestamos.get(position).getNombre_colocadora())));
                    tvNombreCliente.setText((CharSequence)Html.fromHtml((String)("<b>Cliente:</b> " + PrestamosAdapter.this.prestamos.get(position).getNombre_completo())));
                    tvPoblacionCliente.setText((CharSequence)Html.fromHtml((String)("<b>Poblaci\u00f3n:</b> " + PrestamosAdapter.this.prestamos.get(position).getNombre_poblacion())));
                    tvDireccionCliente.setText((CharSequence)Html.fromHtml((String)("<b>Direcci\u00f3n:</b> " + PrestamosAdapter.this.prestamos.get(position).getDireccion_cliente())));
                    tvTelefonoCliente.setText((CharSequence)Html.fromHtml((String)("<b>Tel\u00e9fono:</b> " + PrestamosAdapter.this.prestamos.get(position).getTelefono_cliente())));
                    tvGarantiasCliente.setText((CharSequence)Html.fromHtml((String)("<b>Garant\u00edas:</b> " + PrestamosAdapter.this.prestamos.get(position).getGarantias())));
                    tvMapaCliente.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n</b>"));
                    tvMapaAval.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n</b>"));
                    tvNombreAval.setText((CharSequence)Html.fromHtml((String)("<b>Aval:</b> " + PrestamosAdapter.this.prestamos.get(position).getNombre_aval())));
                    tvDireccionAval.setText((CharSequence)Html.fromHtml((String)("<b>Direcci\u00f3n:</b> " + PrestamosAdapter.this.prestamos.get(position).getDireccion_aval())));
                    tvTelefonoAval.setText((CharSequence)Html.fromHtml((String)("<b>Tel\u00e9fono:</b> " + PrestamosAdapter.this.prestamos.get(position).getTelefono_aval())));
                    tvORAval.setText((CharSequence)Html.fromHtml((String)("<b>Otras referenc\u00edas:</b> " + PrestamosAdapter.this.prestamos.get(position).getOr_aval())));
                    tvGarantiasAval.setText((CharSequence)Html.fromHtml((String)("<b>Garant\u00edas:</b> " + PrestamosAdapter.this.prestamos.get(position).getGarantias_aval())));
                    if (PrestamosAdapter.this.prestamos.get(position).getLatitud() != null && PrestamosAdapter.this.prestamos.get(position).getLongitud() != null) {
                        tvUbicacionCliente.setText((CharSequence)Html.fromHtml((String)"<b>Ver ubicaci\u00f3n"));
                    } else {
                        tvUbicacionCliente.setVisibility(8);
                    }
                    VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
                    RequestQueue requestQueue = vs.getRequestQueue();
                    JSONObject data = new JSONObject();
                    try {
                        data.put("func", (Object)"getCords");
                        data.put("id", (Object)PrestamosAdapter.this.prestamos.get(position).getCliente_id());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)"15", (String)"loadAllData: ");
                    JsonObjectRequest req = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

                        public void onResponse(JSONObject response) {
                            try {
                                if (!response.get("data").toString().equals("false")) {
                                    JSONObject jsonObject = (JSONObject)response.get("data");
                                    final String latitud = jsonObject.getString("latitud");
                                    final String longitud = jsonObject.getString("longitud");
                                    if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                        tvMapaCliente.setText((CharSequence)"");
                                    } else {
                                        tvMapaCliente.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View v) {
                                                Intent intent = new Intent("android.intent.action.VIEW");
                                                intent.setData(Uri.parse((String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud)));
                                                intent.setPackage("com.google.android.apps.maps");
                                                PrestamosAdapter.this.context.startActivity(intent);
                                            }
                                        });
                                    }
                                }
                            }
                            catch (JSONException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                        }
                    });
                    requestQueue.add((Request)req);
                    JSONObject data2 = new JSONObject();
                    try {
                        data2.put("func", (Object)"coordenadasAval");
                        data2.put("aval_id", (Object)PrestamosAdapter.this.prestamos.get(position).getAval_id());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)"16", (String)"loadAllData: ");
                    JsonObjectRequest req2 = new JsonObjectRequest(1, API.urlClientes, data2, (Response.Listener)new Response.Listener<JSONObject>(){

                        public void onResponse(JSONObject response) {
                            try {
                                if (!response.get("data").toString().equals("false")) {
                                    JSONObject jsonObject = (JSONObject)response.get("data");
                                    final String latitud = jsonObject.getString("latitud");
                                    final String longitud = jsonObject.getString("longitud");
                                    if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                        tvMapaAval.setText((CharSequence)"");
                                    } else {
                                        tvMapaAval.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View v) {
                                                Log.d((String)"qpwopeoqpww", (String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                Intent intent = new Intent("android.intent.action.VIEW");
                                                intent.setData(Uri.parse((String)("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud)));
                                                intent.setPackage("com.google.android.apps.maps");
                                                PrestamosAdapter.this.context.startActivity(intent);
                                            }
                                        });
                                    }
                                }
                            }
                            catch (JSONException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, new Response.ErrorListener(){

                        public void onErrorResponse(VolleyError error) {
                        }
                    });
                    requestQueue.add((Request)req2);
                    tvUbicacionCliente.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)("google.navigation:q=" + PrestamosAdapter.this.prestamos.get(position).getLatitud() + "," + PrestamosAdapter.this.prestamos.get(position).getLongitud() + "&mode=d")));
                            i.setPackage("com.google.android.apps.maps");
                            PrestamosAdapter.this.context.startActivity(i);
                        }
                    });
                    tvTelefonoCliente.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Intent intent = new Intent("android.intent.action.DIAL");
                            intent.setData(Uri.parse((String)("tel:" + PrestamosAdapter.this.prestamos.get(position).getTelefono_cliente())));
                            PrestamosAdapter.this.context.startActivity(intent);
                        }
                    });
                    tvTelefonoAval.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            Intent intent = new Intent("android.intent.action.DIAL");
                            intent.setData(Uri.parse((String)("tel:" + PrestamosAdapter.this.prestamos.get(position).getTelefono_aval())));
                            PrestamosAdapter.this.context.startActivity(intent);
                        }
                    });
                    new MaterialAlertDialogBuilder(PrestamosAdapter.this.context).setTitle((CharSequence)"").setView(dialogView).setPositiveButton((CharSequence)"Cerrar", (dialogInterface, i) -> {}).show();
                }
            });
            AlertDialog.Builder builder = new AlertDialog.Builder(PrestamosAdapter.this.context);
            this.btnVerPagos.setOnClickListener(view -> {
                CharSequence[] str = PrestamosAdapter.this.sesion.getString("nombre_perfil", "").equals("COBRADOR") || PrestamosAdapter.this.sesion.getString("nombre_perfil", "").equals("GESTOR") ? new String[]{"Pagar con folio", "Ver semanas", "Hacer comentario", "Tomar fotos", "Ver expediente", "RMD", "Ticket de aviso"} : new String[]{"Pagar con folio", "Ver semanas", "Hacer comentario", "Tomar fotos", "Ver expediente", "RMD"};
                final String[] opciones = new String[]{"", "Efectivo", "Transferencia", "Garant\u00eda"};
                new MaterialAlertDialogBuilder(PrestamosAdapter.this.context).setTitle((CharSequence)"Opciones").setSingleChoiceItems(str, -1, (dialogInterface, i) -> {
                    switch (i) {
                        case 0: {
                            builder.setTitle((CharSequence)(PrestamosAdapter.this.prestamos.get(position).getNombre_completo() + " DEL GRUPO " + PrestamosAdapter.this.prestamos.get(position).getGrupo_poblacion()));
                            View dialogView = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492937, null);
                            String[] semanasText = new String[]{""};
                            builder.setView(dialogView);
                            TextInputLayout tlFolio = (TextInputLayout)dialogView.findViewById(2131297182);
                            TextInputLayout tlPagoRecibido = (TextInputLayout)dialogView.findViewById(2131297214);
                            TextInputLayout tlConcepto = (TextInputLayout)dialogView.findViewById(2131297167);
                            TextView tvCantidadGarantias = (TextView)dialogView.findViewById(2131297270);
                            TextView tvIdGarantias = (TextView)dialogView.findViewById(2131297300);
                            final EditText tvdescripcionGarantias = (EditText)dialogView.findViewById(2131296535);
                            Button btnRegistrarPago = (Button)dialogView.findViewById(2131296448);
                            PrestamosAdapter.this.btnCamGarantiasRetiradas = (Button)dialogView.findViewById(2131296398);
                            Spinner spinnerOptions2 = (Spinner)dialogView.findViewById(2131297057);
                            PrestamosAdapter.this.btnToggleVisibility = (Button)dialogView.findViewById(2131296455);
                            PrestamosAdapter.this.btnToggleVisibility.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View v) {
                                    if (PrestamosAdapter.this.isVisible) {
                                        tvdescripcionGarantias.setVisibility(8);
                                        PrestamosAdapter.this.btnToggleVisibility.setText((CharSequence)"");
                                        PrestamosAdapter.this.btnToggleVisibility.setCompoundDrawablesWithIntrinsicBounds(2131230900, 0, 0, 0);
                                    } else {
                                        tvdescripcionGarantias.setVisibility(0);
                                        PrestamosAdapter.this.btnToggleVisibility.setText((CharSequence)"");
                                        PrestamosAdapter.this.btnToggleVisibility.setCompoundDrawablesWithIntrinsicBounds(2131230901, 0, 0, 0);
                                    }
                                    PrestamosAdapter.this.isVisible = !PrestamosAdapter.this.isVisible;
                                }
                            });
                            String[] pagoMulta = new String[]{"0.00"};
                            CheckBox cbMulta = (CheckBox)dialogView.findViewById(2131296475);
                            CheckBox cbPagarConGarantias = (CheckBox)dialogView.findViewById(2131296476);
                            ArrayAdapter adapter2 = new ArrayAdapter(PrestamosAdapter.this.context, 17367048, (Object[])opciones);
                            adapter2.setDropDownViewResource(0x1090009);
                            spinnerOptions2.setAdapter((SpinnerAdapter)adapter2);
                            TextView textPlaceholder = (TextView)dialogView.findViewById(2131297134);
                            textPlaceholder.setOnClickListener(v -> {
                                textPlaceholder.setVisibility(8);
                                spinnerOptions2.performClick();
                            });
                            btnRegistrarPago.setVisibility(8);
                            this.getGarantias(PrestamosAdapter.this.prestamos.get(position).getCliente_id(), tvCantidadGarantias, cbPagarConGarantias, tvdescripcionGarantias, PrestamosAdapter.this.btnToggleVisibility, tvIdGarantias);
                            spinnerOptions2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                                    String selectedOption = opciones[position];
                                    if (selectedOption.equals("Garant\u00eda")) {
                                        PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(0);
                                        PrestamosAdapter.this.btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View view) {
                                                AlertDialog.Builder builder = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                                builder.setTitle((CharSequence)"Seleccionar imagen");
                                                CharSequence[] opciones = new String[]{"Tomar foto", "Seleccionar de galer\u00eda"};
                                                builder.setItems(opciones, new DialogInterface.OnClickListener(){

                                                    public void onClick(DialogInterface dialogInterface, int which) {
                                                        switch (which) {
                                                            case 0: {
                                                                int permisoCamara = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.CAMERA");
                                                                int permisoAlmacen = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                                                                if (permisoCamara == 0 && permisoAlmacen == 0) {
                                                                    PrestamosAdapter.this.fragment.openCameraIntent();
                                                                    break;
                                                                }
                                                                ActivityCompat.requestPermissions((Activity)((Activity)PrestamosAdapter.this.context), (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
                                                                break;
                                                            }
                                                            case 1: {
                                                                PrestamosAdapter.this.fragment.openGalleryIntent();
                                                            }
                                                        }
                                                    }
                                                });
                                                builder.show();
                                            }
                                        });
                                    } else {
                                        PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(8);
                                    }
                                }

                                public void onNothingSelected(AdapterView<?> parent) {
                                }
                            });
                            this.siguienteFolio(tlFolio);
                            this.cargarSemanas(PrestamosAdapter.this.prestamos.get(position).getId());
                            this.semanasPendientes(PrestamosAdapter.this.prestamos.get(position).getId());
                            cbMulta.setOnCheckedChangeListener((compoundButton, b) -> {
                                pagoMulta[0] = b ? PrestamosAdapter.this.prestamos.get(position).getMonto_multa() : "0.00";
                            });
                            tlPagoRecibido.getEditText().setHint((CharSequence)("Pago Recibido ($" + PrestamosAdapter.this.prestamos.get(position).getPago_semanal() + ")"));
                            cbMulta.setText((CharSequence)"Aplicar multa de $50.00");
                            PrestamosAdapter.this.contenedorSemanas = (FlowLayout)dialogView.findViewById(2131296512);
                            PrestamosAdapter.this.semanasGeneradas = new ArrayList();
                            ArrayList semanasElegidas = new ArrayList();
                            double[] totalPorPagar = new double[]{0.0};
                            for (int x = 0; x < Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getSemanas()); ++x) {
                                Semana sem = new Semana();
                                sem.btnSemana = (Button)LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492902, null, false);
                                sem.btnSemana.setText((CharSequence)String.valueOf(x + 1));
                                sem.setSemana(String.valueOf(x + 1));
                                sem.setCantidad_esperada_pago(PrestamosAdapter.this.prestamos.get(position).getPago_semanal());
                                if (Build.VERSION.SDK_INT >= 26) {
                                    sem.btnSemana.setAutoSizeTextTypeUniformWithConfiguration(4, 10, 1, 2);
                                }
                                sem.btnSemana.setSingleLine(false);
                                sem.btnSemana.setEllipsize(TextUtils.TruncateAt.END);
                                int maxWidthPx = (int)(80.0f * sem.btnSemana.getContext().getResources().getDisplayMetrics().density);
                                sem.btnSemana.setMaxWidth(maxWidthPx);
                                sem.btnSemana.setGravity(17);
                                sem.setCantidad_pendiente("0.00");
                                sem.btnSemana.setOnClickListener(view1 -> {
                                    if (semanasElegidas.contains(sem)) {
                                        if (Build.VERSION.SDK_INT >= 24) {
                                            if (PrestamosAdapter.this.semanasNoPagadasList.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {
                                                sem.btnSemana.setBackgroundColor(PrestamosAdapter.this.context.getResources().getColor(2131099717));
                                                sem.btnSemana.setTextColor(PrestamosAdapter.this.context.getResources().getColor(2131100470));
                                            } else if (PrestamosAdapter.this.semanasPendientesList.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {
                                                sem.btnSemana.setBackgroundColor(PrestamosAdapter.this.context.getResources().getColor(2131100455));
                                                sem.btnSemana.setTextColor(PrestamosAdapter.this.context.getResources().getColor(2131100470));
                                            } else if (PrestamosAdapter.this.semanasAdelantadasList.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {
                                                sem.btnSemana.setBackgroundColor(PrestamosAdapter.this.context.getResources().getColor(2131100446));
                                                sem.btnSemana.setTextColor(PrestamosAdapter.this.context.getResources().getColor(2131100470));
                                            } else {
                                                sem.btnSemana.setBackgroundColor(PrestamosAdapter.this.context.getResources().getColor(2131100430));
                                                sem.btnSemana.setTextColor(PrestamosAdapter.this.context.getResources().getColor(2131099681));
                                            }
                                        }
                                        totalPorPagar[0] = !sem.getCantidad_pendiente().equals("0.00") ? totalPorPagar[0] - Utils.convertirDouble(sem.getCantidad_pendiente()) : totalPorPagar[0] - Utils.convertirDouble(sem.getCantidad_esperada_pago());
                                        tlPagoRecibido.getEditText().setText((CharSequence)(totalPorPagar[0] == 0.0 ? "" : String.valueOf(totalPorPagar[0])));
                                        semanasElegidas.remove(sem);
                                        tlPagoRecibido.getEditText().setEnabled(semanasElegidas.size() <= 1);
                                    } else {
                                        totalPorPagar[0] = !sem.getCantidad_pendiente().equals("0.00") ? totalPorPagar[0] + Utils.convertirDouble(sem.getCantidad_pendiente()) : totalPorPagar[0] + Utils.convertirDouble(sem.getCantidad_esperada_pago());
                                        tlPagoRecibido.getEditText().setText((CharSequence)(totalPorPagar[0] == 0.0 ? "" : String.valueOf(totalPorPagar[0])));
                                        sem.btnSemana.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100431));
                                        sem.btnSemana.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                                        semanasElegidas.add(sem);
                                        tlPagoRecibido.getEditText().setEnabled(semanasElegidas.size() <= 1);
                                    }
                                });
                                PrestamosAdapter.this.semanasGeneradas.add(sem);
                                PrestamosAdapter.this.contenedorSemanas.addView((View)sem.btnSemana);
                            }
                            builder.setCancelable(false);
                            builder.setPositiveButton((CharSequence)"Pagar", (dialogInterface13, i13) -> {
                                if (cbPagarConGarantias.isChecked()) {
                                    AlertDialog.Builder formBuilder = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                    View formView = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492949, null);
                                    formBuilder.setView(formView);
                                    EditText etFechaVenta = (EditText)formView.findViewById(2131296597);
                                    Spinner spinnerLugarVenta = (Spinner)formView.findViewById(2131297056);
                                    EditText etImporte = (EditText)formView.findViewById(2131296605);
                                    EditText etComentarios = (EditText)formView.findViewById(2131296584);
                                    Button btnSubmit = (Button)formView.findViewById(2131296453);
                                    TextView tvSemanas = (TextView)formView.findViewById(2131297329);
                                    ArrayList<String> semanasList = new ArrayList<String>();
                                    for (Semana semana : semanasElegidas) {
                                        semanasList.add(String.valueOf(semana.getSemana()));
                                    }
                                    semanasText[0] = "Semanas: " + String.join((CharSequence)",", semanasList);
                                    tvSemanas.setText((CharSequence)semanasText[0]);
                                    Calendar calendar = Calendar.getInstance();
                                    int year = calendar.get(1);
                                    int month = calendar.get(2);
                                    int day = calendar.get(5);
                                    String currentDate = day + "/" + (month + 1) + "/" + year;
                                    etFechaVenta.setText((CharSequence)currentDate);
                                    etFechaVenta.setOnClickListener(v -> {
                                        DatePickerDialog datePickerDialog = new DatePickerDialog(PrestamosAdapter.this.context, (view2, year1, month1, dayOfMonth) -> {
                                            String selectedDate = dayOfMonth + "/" + (month1 + 1) + "/" + year1;
                                            etFechaVenta.setText((CharSequence)selectedDate);
                                        }, year, month, day);
                                        datePickerDialog.show();
                                    });
                                    ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)PrestamosAdapter.this.context, (int)2130903040, (int)17367048);
                                    adapter.setDropDownViewResource(0x1090009);
                                    spinnerLugarVenta.setAdapter((SpinnerAdapter)adapter);
                                    spinnerLugarVenta.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                                        public void onItemSelected(AdapterView<?> parentView, View selectedItemView, int position, long id2) {
                                            int selectedPosition = position + 1;
                                            Log.d((String)"SpinnerSelection", (String)("Selected position: " + selectedPosition));
                                        }

                                        public void onNothingSelected(AdapterView<?> parentView) {
                                        }
                                    });
                                    formBuilder.setTitle((CharSequence)"Formulario de Garant\u00edas");
                                    formBuilder.setNegativeButton((CharSequence)"Cancelar", (dialog, which) -> dialog.dismiss());
                                    AlertDialog formDialog = formBuilder.create();
                                    formDialog.show();
                                    if (semanasElegidas.size() != 0) {
                                        this.buscarGarantia(PrestamosAdapter.this.prestamos.get(position).getCliente_id());
                                        Log.d((String)"CACHE", (String)("Total semanasElegidas.size(): " + semanasElegidas));
                                        int pagoSemanal = (int)Utils.convertirDouble(PrestamosAdapter.this.prestamos.get(position).getPago_semanal());
                                        String tipo_pagoop = spinnerOptions2.getSelectedItem().toString();
                                        int numeroSemanasElegidas = semanasElegidas.size();
                                        int smonto = pagoSemanal * numeroSemanasElegidas;
                                        etImporte.setText((CharSequence)String.valueOf(smonto));
                                        String importe = etImporte.getText().toString();
                                        Log.d((String)"CACHE", (String)("Total importe.size(): " + importe));
                                        btnSubmit.setOnClickListener(v -> {
                                            String fechaVenta = etFechaVenta.getText().toString();
                                            String semanasText2 = tvSemanas.getText().toString();
                                            String idretiradas = tvIdGarantias.getText().toString();
                                            String semanas = semanasText2.replace("Semanas: ", "").trim();
                                            String concepto = tlConcepto.getEditText().getText().toString();
                                            String folio = tlFolio.getEditText().getText().toString();
                                            String importev = etImporte.getText().toString();
                                            String lugarVenta = spinnerLugarVenta.getSelectedItem().toString();
                                            int lugarVentaPosition = spinnerLugarVenta.getSelectedItemPosition() + 1;
                                            String comentarios = etComentarios.getText().toString();
                                            if (fechaVenta.isEmpty() || importe.isEmpty()) {
                                                Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Por favor, complete todos los campos requeridos.", (int)0).show();
                                            } else {
                                                this.registrarVenta(Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getId()), fechaVenta, lugarVentaPosition, importev, PrestamosAdapter.this.prestamos.get(position).getNumero_tarjeton(), semanas, comentarios, idretiradas, numeroSemanasElegidas, pagoMulta[0], tipo_pagoop, concepto, folio);
                                                Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Formulario enviado con \u00e9xito.", (int)0).show();
                                                formDialog.dismiss();
                                            }
                                        });
                                    } else {
                                        formDialog.dismiss();
                                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Debes elegir una o m\u00e1s semanas a pagar", (int)0).show();
                                    }
                                } else {
                                    ArrayList<String> semanasList = new ArrayList<String>();
                                    for (Semana semana : semanasElegidas) {
                                        semanasList.add(String.valueOf(semana.getSemana()));
                                    }
                                    semanasText[0] = "Semanas: " + String.join((CharSequence)",", semanasList);
                                    Log.d((String)"Debug", (String)("cantidadTotalGarantias: " + PrestamosAdapter.this.cantidadTotalGarantias));
                                    Log.d((String)"Debug", (String)("semanasText[0]: " + semanasText[0]));
                                    Log.d((String)"Debug", (String)("cbPagarConGarantias isChecked: " + cbPagarConGarantias.isChecked()));
                                    if (PrestamosAdapter.this.cantidadTotalGarantias > 0 && semanasText[0].contains("15") && !cbPagarConGarantias.isChecked()) {
                                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"El cliente cuenta con 1 o mas garantias retiradas disponibles", (int)0).show();
                                    } else if (semanasElegidas.size() != 0) {
                                        String concepto = tlConcepto.getEditText().getText().toString();
                                        String folio = tlFolio.getEditText().getText().toString();
                                        String pago_recibido = tlPagoRecibido.getEditText().getText().toString();
                                        String tipo_pagoop = spinnerOptions2.getSelectedItem().toString();
                                        if (semanasElegidas.size() == 1) {
                                            ((Semana)semanasElegidas.get(0)).setCantidad_pendiente(pago_recibido);
                                        }
                                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Guardando, por favor espere...", (int)0).show();
                                        dialogInterface.dismiss();
                                        for (Semana semanaElegida : semanasElegidas) {
                                            Prestamo prestamo;
                                            if (!semanaElegida.getCantidad_pendiente().equals("0.00")) {
                                                prestamo = PrestamosAdapter.this.prestamos.get(position);
                                                this.pagar(prestamo, PrestamosAdapter.this.prestamos.get(position).getId(), semanaElegida.getCantidad_pendiente(), pagoMulta[0], concepto, "", folio, semanaElegida.getSemana(), tipo_pagoop, PrestamosAdapter.this.prestamos.get(position));
                                                this.getFecha(PrestamosAdapter.this.prestamos.get(position).getId(), semanaElegida.getSemana());
                                                continue;
                                            }
                                            prestamo = PrestamosAdapter.this.prestamos.get(position);
                                            this.pagar(prestamo, PrestamosAdapter.this.prestamos.get(position).getId(), semanaElegida.getCantidad_esperada_pago(), pagoMulta[0], concepto, "", folio, semanaElegida.getSemana(), tipo_pagoop, PrestamosAdapter.this.prestamos.get(position));
                                            this.getFecha(PrestamosAdapter.this.prestamos.get(position).getId(), semanaElegida.getSemana());
                                        }
                                        double pago = Utils.convertirDouble(pago_recibido);
                                        NumeroLetras numeroLetras = new NumeroLetras();
                                        String recibido_con_letra = numeroLetras.Convertir(pago + "", "", "", "", "", "", true);
                                        Date c = Calendar.getInstance().getTime();
                                        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                                        String formattedDate = df.format(c);
                                        AlertDialog.Builder builder6 = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                        builder6.setTitle((CharSequence)"Seleccionar Opci\u00f3n").setPositiveButton((CharSequence)"Imprimir Pago", (dialog, which) -> {
                                            try {
                                                BluetoothUtils.context = PrestamosAdapter.this.context;
                                                BluetoothUtils.printPhoto(2131230871);
                                                BluetoothUtils.printText(PrestamosAdapter.this.prestamos.get(position), folio, pago + "", pagoMulta[0], concepto, formattedDate, recibido_con_letra);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }).setNeutralButton((CharSequence)"Compartir", (dialog, which) -> {
                                            String tipo_ticket = "Pago";
                                            PrestamosAdapter.this.fragment.compartirTextoPago(PrestamosAdapter.this.prestamos.get(position), folio, pago + "", pagoMulta[0], concepto, formattedDate, recibido_con_letra, tipo_ticket);
                                        }).setNegativeButton((CharSequence)"Cerrar", (dialog, which) -> dialog.dismiss()).show();
                                        semanasElegidas.clear();
                                        PrestamosAdapter.this.semanasPagadasList.clear();
                                        PrestamosAdapter.this.semanasPagadasConMultaList.clear();
                                        PrestamosAdapter.this.semanasNoPagadasList.clear();
                                        dialogInterface13.cancel();
                                    } else {
                                        Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Debes elegir una o m\u00e1s semanas a pagar", (int)0).show();
                                    }
                                }
                            });
                            builder.setNegativeButton((CharSequence)"Cancelar", (dialogInterface14, i14) -> {});
                            builder.show();
                            break;
                        }
                        case 1: {
                            View dialogView2 = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492967, null);
                            Pago[] pagoSeleccionado = new Pago[1];
                            Log.d((String)"DATA", (String)("Datos almacenados en pagos ANTES" + PrestamosAdapter.this.pagos));
                            PrestamosAdapter.this.pagos = new ArrayList();
                            Log.d((String)"DATA", (String)("Datos almacenados en pagos DESPUES" + PrestamosAdapter.this.pagos));
                            PrestamosAdapter.this.recyclerViewPagos = (RecyclerView)dialogView2.findViewById(2131296983);
                            PrestamosAdapter.this.shimmer = (ShimmerFrameLayout)dialogView2.findViewById(2131297036);
                            Button btnPagar = (Button)dialogView2.findViewById(2131296443);
                            Button btnPagarConMulta = (Button)dialogView2.findViewById(2131296444);
                            Button btnNoPagar = (Button)dialogView2.findViewById(2131296442);
                            Button btnAdelantar = (Button)dialogView2.findViewById(2131296391);
                            btnAdelantar.setOnClickListener(view1 -> {
                                if (PrestamosAdapter.this.pagosAdapter != null && ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() > 0) {
                                    MaterialAlertDialogBuilder builder2 = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                                    builder2.setTitle((CharSequence)("Adelantar pago de la semana " + ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size()));
                                    LayoutInflater inflater = LayoutInflater.from((Context)PrestamosAdapter.this.context);
                                    View dialogView4 = inflater.inflate(2131492945, null);
                                    builder2.setView(dialogView4);
                                    PrestamosAdapter.this.btnCamGarantiasRetiradas = (Button)dialogView4.findViewById(2131296398);
                                    Spinner spinnerOptions = (Spinner)dialogView4.findViewById(2131297057);
                                    TextView textPlaceholder2 = (TextView)dialogView4.findViewById(2131297134);
                                    textPlaceholder2.setOnClickListener(v -> {
                                        textPlaceholder2.setVisibility(8);
                                        spinnerOptions.performClick();
                                    });
                                    ArrayAdapter adapter = new ArrayAdapter(PrestamosAdapter.this.context, 17367048, (Object[])opciones);
                                    adapter.setDropDownViewResource(0x1090009);
                                    spinnerOptions.setAdapter((SpinnerAdapter)adapter);
                                    spinnerOptions.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                                            String selectedOption = opciones[position];
                                            if (selectedOption.equals("Garant\u00eda")) {
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(0);
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener(){

                                                    public void onClick(View view) {
                                                        AlertDialog.Builder builder = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                                        builder.setTitle((CharSequence)"Seleccionar imagen");
                                                        CharSequence[] opciones = new String[]{"Tomar foto", "Seleccionar de galer\u00eda"};
                                                        builder.setItems(opciones, new DialogInterface.OnClickListener(){

                                                            public void onClick(DialogInterface dialogInterface, int which) {
                                                                switch (which) {
                                                                    case 0: {
                                                                        int permisoCamara = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.CAMERA");
                                                                        int permisoAlmacen = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                                                                        if (permisoCamara == 0 && permisoAlmacen == 0) {
                                                                            PrestamosAdapter.this.fragment.openCameraIntent();
                                                                            break;
                                                                        }
                                                                        ActivityCompat.requestPermissions((Activity)((Activity)PrestamosAdapter.this.context), (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        PrestamosAdapter.this.fragment.openGalleryIntent();
                                                                    }
                                                                }
                                                            }
                                                        });
                                                        builder.show();
                                                    }
                                                });
                                            } else {
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(8);
                                            }
                                        }

                                        public void onNothingSelected(AdapterView<?> parent) {
                                        }
                                    });
                                    builder2.setPositiveButton((CharSequence)"Pagar", (dialogInterface15, i15) -> {
                                        PrestamosAdapter.this.prestamo_id = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getId());
                                        String pagoSemanal = PrestamosAdapter.this.prestamos.get(position).getPago_semanal();
                                        pagoSemanal = pagoSemanal + ".00";
                                        Log.d((String)"SQLite", (String)("Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + pagoSemanal));
                                        Log.d((String)"SQLite", (String)("Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + PrestamosAdapter.this.prestamos.get(position).getPago_semanal()));
                                        String tipo_pago = (String)spinnerOptions.getSelectedItem();
                                        for (Pago pago : ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados) {
                                            this.AdelantarpagarSemana(PrestamosAdapter.this.prestamos.get(position), pago.getSemana(), "4", tipo_pago, pagoSemanal);
                                        }
                                        ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.clear();
                                    }).show();
                                } else {
                                    Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Selecciona al menos una semana", (int)0).show();
                                }
                            });
                            btnPagar.setOnClickListener(view1 -> {
                                if (PrestamosAdapter.this.pagosAdapter != null && ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() > 0) {
                                    MaterialAlertDialogBuilder builder2 = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                                    builder2.setTitle((CharSequence)("Pagar " + ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() + " semanas"));
                                    LayoutInflater inflater = LayoutInflater.from((Context)PrestamosAdapter.this.context);
                                    View dialogView4 = inflater.inflate(2131492945, null);
                                    builder2.setView(dialogView4);
                                    PrestamosAdapter.this.btnCamGarantiasRetiradas = (Button)dialogView4.findViewById(2131296398);
                                    Spinner spinnerOptions = (Spinner)dialogView4.findViewById(2131297057);
                                    TextView textPlaceholder2 = (TextView)dialogView4.findViewById(2131297134);
                                    textPlaceholder2.setOnClickListener(v -> {
                                        textPlaceholder2.setVisibility(8);
                                        spinnerOptions.performClick();
                                    });
                                    ArrayAdapter adapter = new ArrayAdapter(PrestamosAdapter.this.context, 17367048, (Object[])opciones);
                                    adapter.setDropDownViewResource(0x1090009);
                                    spinnerOptions.setAdapter((SpinnerAdapter)adapter);
                                    spinnerOptions.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                                            String selectedOption = opciones[position];
                                            if (selectedOption.equals("Garant\u00eda")) {
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(0);
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener(){

                                                    public void onClick(View view) {
                                                        AlertDialog.Builder builder = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                                        builder.setTitle((CharSequence)"Seleccionar imagen");
                                                        CharSequence[] opciones = new String[]{"Tomar foto", "Seleccionar de galer\u00eda"};
                                                        builder.setItems(opciones, new DialogInterface.OnClickListener(){

                                                            public void onClick(DialogInterface dialogInterface, int which) {
                                                                switch (which) {
                                                                    case 0: {
                                                                        int permisoCamara = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.CAMERA");
                                                                        int permisoAlmacen = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                                                                        if (permisoCamara == 0 && permisoAlmacen == 0) {
                                                                            PrestamosAdapter.this.fragment.openCameraIntent();
                                                                            break;
                                                                        }
                                                                        ActivityCompat.requestPermissions((Activity)((Activity)PrestamosAdapter.this.context), (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        PrestamosAdapter.this.fragment.openGalleryIntent();
                                                                    }
                                                                }
                                                            }
                                                        });
                                                        builder.show();
                                                    }
                                                });
                                            } else {
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(8);
                                            }
                                        }

                                        public void onNothingSelected(AdapterView<?> parent) {
                                        }
                                    });
                                    builder2.setPositiveButton((CharSequence)"Pagar", (dialogInterface15, i15) -> {
                                        PrestamosAdapter.this.prestamo_id = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getId());
                                        String pagoSemanal = PrestamosAdapter.this.prestamos.get(position).getPago_semanal();
                                        pagoSemanal = pagoSemanal + ".00";
                                        Log.d((String)"SQLite", (String)("Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + pagoSemanal));
                                        Log.d((String)"SQLite", (String)("Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + PrestamosAdapter.this.prestamos.get(position).getPago_semanal()));
                                        String tipo_pago = (String)spinnerOptions.getSelectedItem();
                                        for (Pago pago : ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados) {
                                            this.pagarSemana(PrestamosAdapter.this.prestamos.get(position), pago.getSemana(), pago.getStatus(), tipo_pago, pagoSemanal);
                                        }
                                        ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.clear();
                                    }).show();
                                } else {
                                    Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Selecciona al menos una semana", (int)0).show();
                                }
                            });
                            btnPagarConMulta.setOnClickListener(view1 -> {
                                if (PrestamosAdapter.this.pagosAdapter != null && ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() > 0) {
                                    MaterialAlertDialogBuilder builder2 = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                                    builder2.setTitle((CharSequence)("Pagar " + ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() + " semanas con multa"));
                                    LayoutInflater inflater = LayoutInflater.from((Context)PrestamosAdapter.this.context);
                                    View dialogView4 = inflater.inflate(2131492945, null);
                                    builder2.setView(dialogView4);
                                    PrestamosAdapter.this.btnCamGarantiasRetiradas = (Button)dialogView4.findViewById(2131296398);
                                    Spinner spinnerOptions = (Spinner)dialogView4.findViewById(2131297057);
                                    TextView textPlaceholder2 = (TextView)dialogView4.findViewById(2131297134);
                                    textPlaceholder2.setOnClickListener(v -> {
                                        textPlaceholder2.setVisibility(8);
                                        spinnerOptions.performClick();
                                    });
                                    ArrayAdapter adapter = new ArrayAdapter(PrestamosAdapter.this.context, 17367048, (Object[])opciones);
                                    adapter.setDropDownViewResource(0x1090009);
                                    spinnerOptions.setAdapter((SpinnerAdapter)adapter);
                                    spinnerOptions.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                                            String selectedOption = opciones[position];
                                            if (selectedOption.equals("Garant\u00eda")) {
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(0);
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener(){

                                                    public void onClick(View view) {
                                                        AlertDialog.Builder builder = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                                        builder.setTitle((CharSequence)"Seleccionar imagen");
                                                        CharSequence[] opciones = new String[]{"Tomar foto", "Seleccionar de galer\u00eda"};
                                                        builder.setItems(opciones, new DialogInterface.OnClickListener(){

                                                            public void onClick(DialogInterface dialogInterface, int which) {
                                                                switch (which) {
                                                                    case 0: {
                                                                        int permisoCamara = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.CAMERA");
                                                                        int permisoAlmacen = ContextCompat.checkSelfPermission((Context)PrestamosAdapter.this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                                                                        if (permisoCamara == 0 && permisoAlmacen == 0) {
                                                                            PrestamosAdapter.this.fragment.openCameraIntent();
                                                                            break;
                                                                        }
                                                                        ActivityCompat.requestPermissions((Activity)((Activity)PrestamosAdapter.this.context), (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        PrestamosAdapter.this.fragment.openGalleryIntent();
                                                                    }
                                                                }
                                                            }
                                                        });
                                                        builder.show();
                                                    }
                                                });
                                            } else {
                                                PrestamosAdapter.this.btnCamGarantiasRetiradas.setVisibility(8);
                                            }
                                        }

                                        public void onNothingSelected(AdapterView<?> parent) {
                                        }
                                    });
                                    builder2.setPositiveButton((CharSequence)"Pagar", (dialogInterface16, i16) -> {
                                        PrestamosAdapter.this.prestamo_id = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getId());
                                        String pagoSemanal = PrestamosAdapter.this.prestamos.get(position).getPago_semanal();
                                        pagoSemanal = pagoSemanal + ".00";
                                        String pagoMultaLocal = PrestamosAdapter.this.prestamos.get(position).getMonto_multa();
                                        Log.d((String)"SQLite", (String)("Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + pagoMultaLocal));
                                        Log.d((String)"SQLite", (String)("Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + PrestamosAdapter.this.prestamos.get(position).getMonto_multa()));
                                        String tipo_pago = (String)spinnerOptions.getSelectedItem();
                                        for (Pago pago : ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados) {
                                            this.pagarConMultaSemana(PrestamosAdapter.this.prestamos.get(position), pago.getSemana(), tipo_pago, pagoSemanal, pagoMultaLocal);
                                        }
                                        ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.clear();
                                    }).show();
                                } else {
                                    Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Selecciona al menos una semana", (int)0).show();
                                }
                            });
                            btnNoPagar.setOnClickListener(view1 -> {
                                if (((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() > 0) {
                                    new MaterialAlertDialogBuilder(PrestamosAdapter.this.context).setTitle((CharSequence)("Marcar " + ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.size() + " semanas como no pagadas")).setPositiveButton((CharSequence)"No pagar", (dialogInterface17, i17) -> {
                                        for (Pago pago : ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados) {
                                            PrestamosAdapter.this.prestamo_id = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getId());
                                            this.noPagarSemana(PrestamosAdapter.this.prestamos.get(position), pago.getSemana(), pago.getTipo_pago());
                                        }
                                        ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.clear();
                                    }).show();
                                } else {
                                    Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Selecciona al menos una semana", (int)0).show();
                                }
                            });
                            PrestamosAdapter.this.pagosAdapter = new PagosAdapter(PrestamosAdapter.this.context, PrestamosAdapter.this.pagos, PrestamosAdapter.this.prestamos.get(position));
                            this.getPagos(PrestamosAdapter.this.prestamos.get(position).getId());
                            PrestamosAdapter.this.pagosAdapter = new PagosAdapter(PrestamosAdapter.this.context, PrestamosAdapter.this.pagos, PrestamosAdapter.this.prestamos.get(position));
                            PrestamosAdapter.this.linearLayoutManager = new LinearLayoutManager(PrestamosAdapter.this.context);
                            PrestamosAdapter.this.recyclerViewPagos.setLayoutManager((RecyclerView.LayoutManager)PrestamosAdapter.this.linearLayoutManager);
                            PrestamosAdapter.this.recyclerViewPagos.setAdapter((RecyclerView.Adapter)PrestamosAdapter.this.pagosAdapter);
                            PrestamosAdapter.this.recyclerViewPagos.getRecycledViewPool().setMaxRecycledViews(0, 0);
                            AlertDialog.Builder builder2 = new AlertDialog.Builder(PrestamosAdapter.this.context);
                            builder2.setTitle((CharSequence)(PrestamosAdapter.this.prestamos.get(position).getNombre_completo() + " DEL GRUPO " + PrestamosAdapter.this.prestamos.get(position).getGrupo_poblacion()));
                            builder2.setView(dialogView2);
                            builder2.setCancelable(false);
                            builder2.setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            });
                            builder2.show();
                            break;
                        }
                        case 2: {
                            View dialogView3 = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131492929, null);
                            TextInputLayout tlComentario = (TextInputLayout)dialogView3.findViewById(2131297164);
                            TextView tvModificacion = (TextView)dialogView3.findViewById(2131297305);
                            AlertDialog.Builder builder3 = new AlertDialog.Builder(PrestamosAdapter.this.context);
                            builder3.setTitle((CharSequence)("HACE COMENTARIO A " + PrestamosAdapter.this.prestamos.get(position).getNombre_completo() + " DEL GRUPO " + PrestamosAdapter.this.prestamos.get(position).getGrupo_poblacion()));
                            tlComentario.getEditText().setText((CharSequence)PrestamosAdapter.this.prestamos.get(position).getComentario());
                            tvModificacion.setText((CharSequence)(PrestamosAdapter.this.prestamos.get(position).getComentario_fecha() == null ? "" : "\u00daltima modifcaci\u00f3n: " + PrestamosAdapter.this.prestamos.get(position).getComentario_fecha()));
                            builder3.setView(dialogView3);
                            builder3.setCancelable(false);
                            builder3.setPositiveButton((CharSequence)"Guardar", (dialogInterface1, i1) -> this.hacerComentario(PrestamosAdapter.this.prestamos.get(position), tlComentario.getEditText().getText().toString()));
                            builder3.setNegativeButton((CharSequence)"Cerrar", (dialogInterface12, i12) -> {});
                            builder3.show();
                            break;
                        }
                        case 3: {
                            dialogInterface.dismiss();
                            Bundle args2 = new Bundle();
                            String idCliente = PrestamosAdapter.this.prestamos.get(position).getCliente_id();
                            String prestamoAvalNombre = PrestamosAdapter.this.prestamos.get(position).getNombre_aval();
                            DatabaseHelper clienteMigration = new DatabaseHelper(PrestamosAdapter.this.context);
                            SQLiteDatabase db = clienteMigration.getReadableDatabase();
                            Cliente cliente = clienteMigration.getClienteById(db, idCliente);
                            String personJsonString2 = Utils.getGsonParser().toJson((Object)cliente);
                            args2.putString("cliente", personJsonString2);
                            args2.putString("avalNombre", prestamoAvalNombre);
                            Log.d((String)"DEBUG1", (String)("ARREGLO EN A ENVIAR DE PRESTAMOS A CLIENTES DOCUMENTOS................" + cliente));
                            Log.d((String)"DEBUG1", (String)("prestamoAvalNombre EN A ENVIAR DE PRESTAMOS A CLIENTES DOCUMENTOS................" + prestamoAvalNombre));
                            CustomDialogFragment2 dialogFragment2 = new CustomDialogFragment2();
                            dialogFragment2.setArguments(args2);
                            dialogFragment2.show(((FragmentActivity)PrestamosAdapter.this.context).getSupportFragmentManager(), "CustomDialogFragment");
                            break;
                        }
                        case 4: {
                            dialogInterface.dismiss();
                            Bundle args = new Bundle();
                            String personJsonString = Utils.getGsonParser().toJson((Object)PrestamosAdapter.this.prestamos.get(position));
                            String personJsonString3 = PrestamosAdapter.this.prestamos.get(position).getCliente_id();
                            args.putString("cliente", personJsonString);
                            args.putString("clienteId", personJsonString3);
                            Log.d((String)"DEBUG1", (String)("ARREGLO EN A ENVIAR DE PRESTAMOS A CLIENTES DOCUMENTOS................" + personJsonString));
                            CustomDialogFragment dialogFragment = new CustomDialogFragment();
                            dialogFragment.setArguments(args);
                            dialogFragment.show(((FragmentActivity)PrestamosAdapter.this.context).getSupportFragmentManager(), "CustomDialogFragment");
                            break;
                        }
                        case 5: {
                            dialogInterface.dismiss();
                            final String prestamoId = PrestamosAdapter.this.prestamos.get(position).getId();
                            SharedPreferences sesion = PrestamosAdapter.this.context.getSharedPreferences("sesion", 0);
                            final String empleado_id = sesion.getString("id", null);
                            final RMDController rmdC = new RMDController(PrestamosAdapter.this.context, null);
                            String rmdCount = rmdC.getRMDSCount(empleado_id);
                            if (Objects.equals(rmdCount, "0")) {
                                if (NetworkChange.isConnectedToInternet(PrestamosAdapter.this.context)) {
                                    AlertDialog.Builder builderCantidad = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                    View dialogLayout = LayoutInflater.from((Context)PrestamosAdapter.this.context).inflate(2131493055, null);
                                    builderCantidad.setView(dialogLayout);
                                    final TextInputLayout tlCantidad = (TextInputLayout)dialogLayout.findViewById(2131297158);
                                    builderCantidad.setTitle((CharSequence)"Preparar RMDs").setPositiveButton((CharSequence)"Crear", new DialogInterface.OnClickListener(){

                                        public void onClick(final DialogInterface dialog, int id2) {
                                            rmdC.prepararRMDS(tlCantidad.getEditText().getText().toString(), empleado_id, new RMDController.prerararRMDSCallback(){

                                                @Override
                                                public void onSuccess(String response) {
                                                    dialog.dismiss();
                                                    Bundle bundle = new Bundle();
                                                    bundle.putString("prestamoId", prestamoId);
                                                    Navigation.findNavController((Activity)((Activity)PrestamosAdapter.this.context), (int)2131296862).navigate(2131296522, bundle);
                                                }

                                                @Override
                                                public void onError(String error) {
                                                }

                                                @Override
                                                public void onSucess() {
                                                    dialog.dismiss();
                                                    Bundle bundle = new Bundle();
                                                    bundle.putString("prestamoId", prestamoId);
                                                    Navigation.findNavController((Activity)((Activity)PrestamosAdapter.this.context), (int)2131296862).navigate(2131296522, bundle);
                                                }
                                            });
                                        }
                                    }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                                        public void onClick(DialogInterface dialog, int id2) {
                                            dialog.dismiss();
                                        }
                                    });
                                    AlertDialog dialog = builderCantidad.create();
                                    dialog.show();
                                    break;
                                }
                                AlertDialog.Builder builderInternet = new AlertDialog.Builder(PrestamosAdapter.this.context);
                                builderInternet.setTitle((CharSequence)"No hay conexi\u00f3n a internet").setMessage((CharSequence)"No se pueden preparar RMDs").setPositiveButton((CharSequence)"Aceptar", new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialog, int id2) {
                                        dialog.dismiss();
                                    }
                                });
                                AlertDialog dialog = builderInternet.create();
                                dialog.show();
                                break;
                            }
                            Bundle bundle = new Bundle();
                            bundle.putString("prestamoId", prestamoId);
                            Navigation.findNavController((Activity)((Activity)PrestamosAdapter.this.context), (int)2131296862).navigate(2131296522, bundle);
                            break;
                        }
                        case 6: {
                            dialogInterface.dismiss();
                            PrestamosAdapter.this.pagos2 = new ArrayList();
                            PrestamosAdapter.this.pagosAdapter = new PagosAdapter(PrestamosAdapter.this.context, PrestamosAdapter.this.pagos2, PrestamosAdapter.this.prestamos.get(position));
                            this.getPagos2(PrestamosAdapter.this.prestamos.get(position).getId(), position);
                        }
                    }
                }).show();
            });
            PrestamoController pc = new PrestamoController(PrestamosAdapter.this.context);
            String status = pc.getStatus(PrestamosAdapter.this.prestamos.get(position).getId());
            if (Objects.equals(status, "4")) {
                this.prestamo_item_bg.setBackgroundColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100446));
                this.tvTarjetonPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvClientePrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
                this.tvMontoPrestamo.setTextColor(ContextCompat.getColor((Context)PrestamosAdapter.this.context, (int)2131100470));
            }
        }

        private void CambiarAval(String prestamo_id, String aval_id) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"CambiarAvalPrestamo");
                data.put("id", (Object)prestamo_id);
                data.put("aval_id", (Object)aval_id);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d((String)"DEBUG", (String)("El aval_id DESPUES de guardar es: " + aval_id));
            Log.d((String)"DEBUG", (String)("El prestamo_id DESPUES de guardar es: " + prestamo_id));
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Se ha cambiado el AVAL", (int)0).show();
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void cargarPrestamosConsulta() {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(() -> {
                DatabaseHelper dbHelper = new DatabaseHelper(PrestamosAdapter.this.context);
                SQLiteDatabase db = dbHelper.getReadableDatabase();
                Log.d((String)"PagosWorker", (String)"Entro en LA CONSULTA SQL DESDE ADAPTER.............................");
                String query = "SELECT prestamos.id, prestamos.cliente_id, clientes.nombre_completo, clientes.direccion, clientes.telefono, clientes.garantias, prestamos.status, prestamos.fecha_prestamo, prestamos.monto_prestado, colocadoras.nombre_completo AS nombre_colocadora, avales.nombre_completo AS nombre_aval, avales.direccion AS direccion_aval, avales.telefono AS telefono_aval, rutas.nombre_ruta AS nombre_ruta, poblaciones.nombre_poblacion AS nombre_poblacion, poblaciones.monto_multa, configuracion_semanas.cantidad AS semanas, MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 14 and prestamos.modalidad_semanas = 1 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_14, MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 19 and prestamos.modalidad_semanas = 2 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_19, COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) as tiene_pendientes, COUNT(CASE WHEN pagos.status = 3 THEN pagos.id END) AS tiene_multas, COUNT(CASE WHEN pagos.folio is not null and pagos.folio != 0 THEN pagos.id END ) as tiene_folios, prestamos.created_at, prestamos.updated_at, prestamos.numero_tarjeton, poblaciones.grupo, avales.garantias AS garantias_aval, avales.otras_referencias  AS otras_referencias_aval, prestamos.pago_semanal, clientes.ruta_id, clientes.poblacion_id, prestamos.modalidad_semanas, prestamos.aval_id FROM prestamos JOIN clientes ON prestamos.cliente_id = clientes.id LEFT JOIN colocadoras ON clientes.colocadora_id = colocadoras.id LEFT JOIN avales ON prestamos.aval_id = avales.id LEFT JOIN rutas ON clientes.ruta_id = rutas.id LEFT JOIN poblaciones ON clientes.poblacion_id = poblaciones.id LEFT JOIN configuracion_semanas ON prestamos.modalidad_semanas = configuracion_semanas.id LEFT JOIN pagos ON prestamos.id = pagos.prestamo_id WHERE prestamos.status NOT IN (1, 2) GROUP BY prestamos.id ORDER BY prestamos.id DESC";
                Cursor cursor = db.rawQuery(query, null);
                PrestamosAdapter.this.prestamos.clear();
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                        String clienteId = cursor.getString(cursor.getColumnIndexOrThrow("cliente_id"));
                        if (prestamoId != null && !prestamoId.isEmpty() && clienteId != null && !clienteId.isEmpty()) {
                            Prestamo prestamo = new Prestamo(prestamoId, clienteId, cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")), cursor.getString(cursor.getColumnIndexOrThrow("direccion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion")) : "", cursor.getString(cursor.getColumnIndexOrThrow("telefono")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono")) : "", cursor.getString(cursor.getColumnIndexOrThrow("garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias")) : "", cursor.getString(cursor.getColumnIndexOrThrow("status")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("status")) : "", cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) : "", cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) : "", cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) : "", cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) : "", cursor.getString(cursor.getColumnIndexOrThrow("semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("semanas")) : "", cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("created_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("created_at")) : "", cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) : "", cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) : "", cursor.getString(cursor.getColumnIndexOrThrow("grupo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo")) : "0", cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) : "", cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) : "", cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) : "", cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) : "", cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) : "", cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) : "");
                            PrestamosAdapter.this.prestamos.add(prestamo);
                            continue;
                        }
                        Log.e((String)"SQLiteClientes", (String)"Registro con id o cliente_id nulo encontrado, omitiendo registro.");
                    } while (cursor.moveToNext());
                    cursor.close();
                }
                db.close();
                Log.d((String)"PrestamosWorker", (String)("Total de registros en LISTA prestamos DESPUES DE CONSULTA: " + PrestamosAdapter.this.prestamos));
                int totalRegistros = PrestamosAdapter.this.prestamos.size();
                Log.d((String)"SQLiteClientes", (String)("Total de registros en SQLite EN CONSULTA SQL: " + totalRegistros));
                if (totalRegistros > 0) {
                    new Handler(Looper.getMainLooper()).post(() -> PrestamosFragment.updateUIWithPrestamos(PrestamosAdapter.this.prestamos));
                } else {
                    Log.d((String)"ClientesFragment", (String)"No hay registros o la tarea no est\u00e1 completa.");
                }
                executor.shutdown();
            });
        }

        private void buscarGarantia(String cliente_id) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"buscarGarantia");
                data.put("cliente_id", (Object)cliente_id);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d((String)"17", (String)"loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        String status = response.get("status").toString();
                        if (status.equals("success")) {
                            JSONArray dataArray = response.getJSONArray("data");
                            if (dataArray.length() > 0) {
                                JSONObject firstItem = dataArray.getJSONObject(0);
                                PrestamosAdapter.this.idgarantia = firstItem.getInt("idgarantias_retiradas");
                                Log.d((String)"CACHE", (String)("idgarantia: " + PrestamosAdapter.this.idgarantia));
                            } else {
                                Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"No se encontr\u00f3 la garant\u00eda.", (int)0).show();
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void registrarVenta(final int prestamo_id, final String fecha, int lugar, final String importe, String tarjeton, final String semana, final String comentario, String idretiradas, final int numeroSemanasElegidas, final String pago_multa, final String tipo_pago, final String concepto, final String folio) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            Log.d((String)"CACHE", (String)("prestamo_id prestamo_id: " + PrestamosAdapter.this.idgarantia));
            JSONObject data = new JSONObject();
            final SimpleDateFormat inputFormat = new SimpleDateFormat("d/M/yyyy", Locale.getDefault());
            final SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            try {
                Date date = inputFormat.parse(fecha);
                String formattedDate = outputFormat.format(date);
                data.put("func", (Object)"pagar_garantia");
                data.put("id", PrestamosAdapter.this.idgarantia);
                data.put("fecha", (Object)formattedDate);
                data.put("lugar", lugar);
                data.put("importe", (Object)importe);
                data.put("tarjeton", (Object)tarjeton);
                data.put("semana", (Object)semana);
                data.put("comentario", (Object)comentario);
                data.put("idretiradas", (Object)idretiradas);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (java.text.ParseException e) {
                throw new RuntimeException(e);
            }
            Log.d((String)"DATA", (String)data.toString());
            Log.d((String)"18", (String)"loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        String data = response.get("status").toString();
                        Date date = inputFormat.parse(fecha);
                        if (data.equals("success")) {
                            String formattedDate = outputFormat.format(date);
                            int can = Integer.parseInt(importe) / numeroSemanasElegidas;
                            PrestamosViewHolder.this.actualizarPagoGarantia(String.valueOf(prestamo_id), semana, String.valueOf(can), comentario, pago_multa, tipo_pago, concepto, folio, formattedDate);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    catch (java.text.ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void actualizarPagoGarantia(String prestamo_id, String semana, String importe, String comentario, String pago_multa, String tipo_pago, String concepto, String folio, String formattedDate) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"ActualizarSemanaGarantia");
                data.put("tarjeton", (Object)prestamo_id);
                data.put("semana", (Object)semana);
                data.put("importe", (Object)importe);
                data.put("comentario", (Object)comentario);
                data.put("pago_multa", (Object)pago_multa);
                data.put("empleado_id", (Object)PrestamosAdapter.this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
                data.put("concepto", (Object)concepto);
                data.put("folio", (Object)folio);
                data.put("fecha", (Object)formattedDate);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d((String)"DATA", (String)data.toString());
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        String data = response.get("status").toString();
                        if (data.equals("success")) {
                            LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void getGarantias(final String cliente_id, final TextView tvCantidadGarantias, final CheckBox cbPagarConGarantias, final EditText tvdescripcionGarantias, final Button btnToggleVisibility, final TextView tvIdGarantias) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            PrestamosAdapter.this.cantidadTotalGarantias = 0;
            try {
                data.put("func", (Object)"getGarantiasRetiradas");
                data.put("cliente_id", (Object)cliente_id);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d((String)"getGarantias", (String)("getGarantias cliente_id: " + cliente_id));
            Log.d((String)"19", (String)"loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlClientes, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        Log.d((String)"getGarantias", (String)("Response: " + response.toString()));
                        JSONArray dataArray = response.getJSONArray("data");
                        if (dataArray.length() > 0) {
                            StringBuilder descGarantiasBuilder = new StringBuilder();
                            StringBuilder idsGarantiasBuilder = new StringBuilder();
                            for (int i = 0; i < dataArray.length(); ++i) {
                                JSONObject obj = dataArray.getJSONObject(i);
                                Log.d((String)"getGarantias", (String)("Data: " + obj.toString()));
                                int cantidadGarantias = obj.getInt("cantidad_garantias");
                                PrestamosAdapter.this.cantidadTotalGarantias += cantidadGarantias;
                                String descGarantias = obj.getString("g_descripcion");
                                if (descGarantiasBuilder.length() > 0) {
                                    descGarantiasBuilder.append(", ");
                                }
                                descGarantiasBuilder.append(descGarantias);
                                String idsGarantias = obj.getString("idgarantias_retiradas");
                                if (idsGarantiasBuilder.length() > 0) {
                                    idsGarantiasBuilder.append(", ");
                                }
                                idsGarantiasBuilder.append(idsGarantias);
                            }
                            tvdescripcionGarantias.setText((CharSequence)descGarantiasBuilder.toString());
                            tvIdGarantias.setText((CharSequence)idsGarantiasBuilder.toString());
                            String textoGarantias = "Garant\u00edas retiradas disponibles: " + PrestamosAdapter.this.cantidadTotalGarantias;
                            tvCantidadGarantias.setText((CharSequence)textoGarantias);
                            if (PrestamosAdapter.this.cantidadTotalGarantias > 0) {
                                btnToggleVisibility.setVisibility(0);
                                tvCantidadGarantias.setVisibility(0);
                                cbPagarConGarantias.setVisibility(0);
                            } else {
                                btnToggleVisibility.setVisibility(8);
                                tvCantidadGarantias.setVisibility(8);
                                cbPagarConGarantias.setVisibility(8);
                            }
                        } else {
                            Log.d((String)"getGarantias", (String)("No data found for cliente_id: " + cliente_id));
                            btnToggleVisibility.setVisibility(8);
                            tvCantidadGarantias.setVisibility(8);
                            cbPagarConGarantias.setVisibility(8);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.e((String)"getGarantias", (String)("Error: " + error.toString()));
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            requestQueue.add((Request)request);
        }

        private void hacerComentario(Prestamo prestamo, String comentario) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"hacerComentario");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("comentario", (Object)comentario);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPrestamos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        String data = response.get("status").toString();
                        if (data.equals("success")) {
                            Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Se ha hecho el comentario", (int)0).show();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void AdelantarpagarSemana(final Prestamo prestamo, final String semana, final String status, final String tipo_pago, final String pagoSemanal) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            final String pagoMultaLocal = "0.00";
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"pagarSiguienteAdelantado");
                data.put("prestamo_id", PrestamosAdapter.this.prestamo_id);
                data.put("semana", (Object)semana);
                data.put("statusPago", (Object)status);
                data.put("empleado_id", (Object)PrestamosAdapter.this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        if (response.getString("status").equals("success")) {
                            String updatedAt = response.getJSONObject("data").getString("updated_at");
                            Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                            PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, status, PrestamosAdapter.this.sesion.getString("id", "0"), "", pagoSemanal, pagoMultaLocal, "", "on", "", updatedAt);
                            PrestamosViewHolder.this.getPagos(prestamo.getId());
                            LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, PrestamosAdapter.this.context) == 1 || ErrorChecker.checker(error, PrestamosAdapter.this.context) == 4) {
                        PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, status, PrestamosAdapter.this.sesion.getString("id", "0"), "", pagoSemanal, pagoMultaLocal, "", "off", "", "");
                        ((PrestamosAdapter)PrestamosAdapter.this).pagosAdapter.pagosSeleccionados.clear();
                        PrestamosViewHolder.this.getPagos(prestamo.getId());
                        LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                    }
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void pagarSemana(final Prestamo prestamo, final String semana, String status, final String tipo_pago, final String pagoSemanal) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            final String pagoMultaLocal = "0.00";
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"pagarSiguiente");
                data.put("prestamo_id", PrestamosAdapter.this.prestamo_id);
                data.put("semana", (Object)semana);
                data.put("statusPago", (Object)status);
                data.put("empleado_id", (Object)PrestamosAdapter.this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        if (response.getString("status").equals("success")) {
                            String updatedAt = response.getJSONObject("data").getString("updated_at");
                            Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                            PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, "1", PrestamosAdapter.this.sesion.getString("id", "0"), "", pagoSemanal, pagoMultaLocal, "", "on", "", updatedAt);
                            PrestamosViewHolder.this.getPagos(prestamo.getId());
                            LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, PrestamosAdapter.this.context) == 1 || ErrorChecker.checker(error, PrestamosAdapter.this.context) == 4) {
                        PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, "1", PrestamosAdapter.this.sesion.getString("id", "0"), "", pagoSemanal, pagoMultaLocal, "", "off", "", "");
                        PrestamosViewHolder.this.getPagos(prestamo.getId());
                        LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                    }
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        @SuppressLint(value={"Range"})
        private void actualizarPagoEnSQLite(Prestamo prestamo, int prestamo_id, String semana, String tipo_pago, String status, String empleado_id, String concepto, String pagoSemanal, String pagoMultaLocal, String tipo_p, String off, String folio, String updatedAt) {
            int filasActualizadas;
            double pagoTotalNuevo;
            DatabaseHelper dbHelper = new DatabaseHelper(PrestamosAdapter.this.context);
            SQLiteDatabase db = dbHelper.getWritableDatabase();
            ContentValues valores = new ContentValues();
            valores.put("prestamo_id", Integer.valueOf(prestamo_id));
            valores.put("semana", semana);
            valores.put("tipo_pago", tipo_pago);
            valores.put("status", status);
            valores.put("empleado_id", empleado_id);
            valores.put("concepto", concepto);
            valores.put("cantidad_multa", pagoMultaLocal);
            if (!folio.isEmpty()) {
                valores.put("folio", folio);
            } else {
                valores.put("folio", "0");
            }
            long timestamp = System.currentTimeMillis();
            if (off.equals("off")) {
                valores.put("sinc", "1");
                Log.d((String)"PrestamosFragment", (String)"ENTRO EN MODO OFFLINE EL PAGO.......");
                timestamp += 10000L;
            } else {
                Log.d((String)"PrestamosFragment", (String)"ENTRO EN MODO CON CONEXION EL PAGO.......: ");
                timestamp -= 10000L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            String formattedDate = sdf.format(new Date(timestamp));
            valores.put("updated_at", formattedDate);
            if (!updatedAt.equals("")) {
                Log.d((String)"PrestamosFragment", (String)("ENTRO EN MODO CON CONEXION EL PAGO + regreso el tiempo del servidor.......: " + updatedAt));
                valores.put("updated_at", updatedAt);
            }
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            String formattedDate2 = sdf2.format(new Date(timestamp));
            valores.put("fecha_pago_realizada", formattedDate2);
            String cantidadNormalExistenteStr = "0.00";
            String queryNormal = "SELECT cantidad_normal_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
            Cursor cursorNormal = db.rawQuery(queryNormal, new String[]{String.valueOf(prestamo_id), semana});
            if (cursorNormal.moveToFirst()) {
                cantidadNormalExistenteStr = cursorNormal.getString(cursorNormal.getColumnIndex("cantidad_normal_pagada"));
            }
            cursorNormal.close();
            double cantidadNormalExistente = Utils.convertirDouble(cantidadNormalExistenteStr);
            double cantidadPagada = Utils.convertirDouble(pagoSemanal);
            double nuevaCantidadNormalPagada = cantidadNormalExistente + cantidadPagada;
            DecimalFormat decimalFormat = new DecimalFormat("#.00");
            String pagoNormalTotCantidad = decimalFormat.format(nuevaCantidadNormalPagada);
            valores.put("cantidad_normal_pagada", pagoNormalTotCantidad);
            valores.put("recuperado", pagoNormalTotCantidad);
            String cantidadTotalExistenteStr = "0.00";
            String queryTotal = "SELECT cantidad_total_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
            Cursor cursorTotal = db.rawQuery(queryTotal, new String[]{String.valueOf(prestamo_id), semana});
            if (cursorTotal.moveToFirst()) {
                cantidadTotalExistenteStr = cursorTotal.getString(cursorTotal.getColumnIndex("cantidad_total_pagada"));
            }
            cursorTotal.close();
            double cantidadTotalExistente = Utils.convertirDouble(cantidadTotalExistenteStr);
            double nuevaCantidadTotalPagada = pagoTotalNuevo = Utils.convertirDouble(pagoNormalTotCantidad) + Utils.convertirDouble(pagoMultaLocal);
            String pagoTotCantidad = decimalFormat.format(nuevaCantidadTotalPagada);
            Log.d((String)"SQLite", (String)("No se pudo actualizar el pago en SQLite para cantidadTotalExistente: " + cantidadTotalExistente));
            Log.d((String)"SQLite", (String)("No se pudo actualizar el pago en SQLite para pagoTotalNuevo: " + pagoTotalNuevo));
            Log.d((String)"SQLite", (String)("No se pudo actualizar el pago en SQLite para pagoNormalTotCantidad: " + pagoNormalTotCantidad));
            Log.d((String)"SQLite", (String)("No se pudo actualizar el pago en SQLite para pagoMultaLocal: " + pagoMultaLocal));
            Log.d((String)"SQLite", (String)("No se pudo actualizar el pago en SQLite para nuevaCantidadTotalPagada: " + nuevaCantidadTotalPagada));
            valores.put("cantidad_total_pagada", pagoTotCantidad);
            double pago_semana = Utils.convertirDouble(prestamo.getPago_semanal());
            double pendiente_final = pago_semana - nuevaCantidadNormalPagada;
            if (pendiente_final > 0.0) {
                String pagoPenCantidad = decimalFormat.format(pendiente_final);
                valores.put("cantidad_pendiente", pagoPenCantidad);
            } else {
                valores.put("cantidad_pendiente", "0.00");
            }
            int tiene_multas = Integer.parseInt(prestamo.getTiene_multas());
            int tiene_pendientes = Integer.parseInt(prestamo.getTiene_pendientes());
            int tiene_folios = Integer.parseInt(prestamo.getTiene_folios());
            if ("14".equals(semana) || "19".equals(semana) || "15".equals(semana) || "20".equals(semana)) {
                Log.d((String)"DEBUG", (String)"Semana coincide con 14 o 19");
                if (tiene_multas == 0 && tiene_pendientes == 0 && tiene_folios == 0) {
                    String ultimaSemana = "14".equals(semana) ? "15" : "20";
                    DecimalFormat decimalFormat4 = new DecimalFormat("#.00");
                    String cantidadPagadaFormatted = decimalFormat4.format(cantidadPagada);
                    ContentValues valoresUltimaSemana = new ContentValues();
                    valoresUltimaSemana.put("prestamo_id", Integer.valueOf(prestamo_id));
                    valoresUltimaSemana.put("semana", ultimaSemana);
                    valoresUltimaSemana.put("status", "2");
                    valoresUltimaSemana.put("empleado_id", empleado_id);
                    valoresUltimaSemana.put("concepto", "Semana omitida");
                    valoresUltimaSemana.put("cantidad_normal_pagada", cantidadPagadaFormatted);
                    valoresUltimaSemana.put("cantidad_total_pagada", cantidadPagadaFormatted);
                    valoresUltimaSemana.put("updated_at", formattedDate);
                    valoresUltimaSemana.put("fecha_pago_realizada", formattedDate2);
                    long insertResult = db.update("pagos", valoresUltimaSemana, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), ultimaSemana});
                    if (insertResult != -1L) {
                        Log.d((String)"SQLite", (String)("Registro insertado en la \u00faltima semana de pago con status 2: Semana " + ultimaSemana));
                        ContentValues valoresPrestamo = new ContentValues();
                        valoresPrestamo.put("status", "1");
                        int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                        if (updatePrestamoResult > 0) {
                            Log.d((String)"SQLite", (String)("Status del pr\u00e9stamo actualizado a 1 para prestamo_id: " + prestamo_id));
                        } else {
                            Log.d((String)"SQLite", (String)("Error al actualizar el status del pr\u00e9stamo para prestamo_id: " + prestamo_id));
                        }
                    } else {
                        Log.d((String)"SQLite", (String)"Error al insertar registro en la \u00faltima semana de pago");
                    }
                }
                if (tiene_pendientes == 0 || "15".equals(semana) || "20".equals(semana)) {
                    ContentValues valoresPrestamo = new ContentValues();
                    valoresPrestamo.put("status", "1");
                    int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                    if (updatePrestamoResult > 0) {
                        Log.d((String)"SQLite", (String)("Status del pr\u00e9stamo actualizado a 1 para prestamo_id: " + prestamo_id));
                    } else {
                        Log.d((String)"SQLite", (String)("Error al actualizar el status del pr\u00e9stamo para prestamo_id: " + prestamo_id));
                    }
                }
            }
            if ((filasActualizadas = db.update("pagos", valores, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), semana})) > 0) {
                Log.d((String)"SQLite", (String)("Pago actualizado correctamente en SQLite para prestamo_id: " + prestamo_id + ", semana: " + semana));
            } else {
                Log.d((String)"SQLite", (String)("No se pudo actualizar el pago en SQLite para prestamo_id: " + prestamo_id + ", semana: " + semana));
            }
            db.close();
        }

        private void pagarConMultaSemana(final Prestamo prestamo, final String semana, final String tipo_pago, final String pagoSemanal, final String pagoMultaLocal) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"pagarSiguienteConMulta");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("semana", (Object)semana);
                data.put("statusPago", (Object)"0");
                data.put("empleado_id", (Object)PrestamosAdapter.this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d((String)"DATA", (String)data.toString());
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        if (response.getString("status").equals("success")) {
                            String updatedAt = response.getJSONObject("data").getString("updated_at");
                            Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                            PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, "3", PrestamosAdapter.this.sesion.getString("id", "0"), "", pagoSemanal, pagoMultaLocal, tipo_pago, "on", "", updatedAt);
                            PrestamosViewHolder.this.getPagos(prestamo.getId());
                            LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, PrestamosAdapter.this.context) == 1 || ErrorChecker.checker(error, PrestamosAdapter.this.context) == 4) {
                        PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, "3", PrestamosAdapter.this.sesion.getString("id", "0"), "", pagoSemanal, pagoMultaLocal, tipo_pago, "off", "", "");
                        PrestamosViewHolder.this.getPagos(prestamo.getId());
                        LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                    }
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void noPagarSemana(final Prestamo prestamo, final String semana, final String tipo_pago) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"noPagarSiguiente");
                data.put("prestamo_id", (Object)prestamo.getId());
                data.put("semana", (Object)semana);
                data.put("empleado_id", (Object)PrestamosAdapter.this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        if (response.getString("status").equals("success")) {
                            String updatedAt = response.getJSONObject("data").getString("updated_at");
                            Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                            PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, "-1", PrestamosAdapter.this.sesion.getString("id", "0"), "", "0.00", "0.00", tipo_pago, "on", "", updatedAt);
                            PrestamosViewHolder.this.getPagos(prestamo.getId());
                            PrestamosViewHolder.this.cargarPrestamosConsulta();
                            LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, PrestamosAdapter.this.context) == 1 || ErrorChecker.checker(error, PrestamosAdapter.this.context) == 4) {
                        PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, PrestamosAdapter.this.prestamo_id, semana, tipo_pago, "-1", PrestamosAdapter.this.sesion.getString("id", "0"), "", "0.00", "0.00", tipo_pago, "off", "", "");
                        PrestamosViewHolder.this.getPagos(prestamo.getId());
                        PrestamosViewHolder.this.cargarPrestamosConsulta();
                        LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                    }
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void getPagos(String prestamoId) {
            if (PrestamosAdapter.this.pagosAdapter == null) {
                Log.e((String)"getPagos", (String)("Error: pagosAdapter is null." + prestamoId));
                return;
            }
            DatabaseHelper pagoMigration = new DatabaseHelper(PrestamosAdapter.this.context);
            List<Pago> pagosDesdeDb = pagoMigration.getPagosFromDatabase(prestamoId);
            PrestamosAdapter.this.pagosAdapter.clear();
            PrestamosAdapter.this.pagos.clear();
            PrestamosAdapter.this.pagos.addAll(pagosDesdeDb);
            PrestamosAdapter.this.pagosAdapter.addAll(PrestamosAdapter.this.pagos);
            PrestamosAdapter.this.pagosAdapter.notifyItemRangeChanged(PrestamosAdapter.this.pagos.size(), 1);
            PrestamosAdapter.this.shimmer.startShimmer();
            PrestamosAdapter.this.shimmer.setVisibility(8);
            PrestamosAdapter.this.recyclerViewPagos.setVisibility(0);
        }

        private void getPagosFolio(String prestamoId, Prestamo prestamo1) {
            PrestamosAdapter.this.pagos = new ArrayList();
            PrestamosAdapter.this.pagosAdapter = new PagosAdapter(PrestamosAdapter.this.context, PrestamosAdapter.this.pagos, prestamo1);
            DatabaseHelper pagoMigration = new DatabaseHelper(PrestamosAdapter.this.context);
            List<Pago> pagosDesdeDb = pagoMigration.getPagosFromDatabase(prestamoId);
            PrestamosAdapter.this.pagosAdapter.clear();
            PrestamosAdapter.this.pagos.clear();
            PrestamosAdapter.this.pagos.addAll(pagosDesdeDb);
            PrestamosAdapter.this.pagosAdapter.addAll(PrestamosAdapter.this.pagos);
            PrestamosAdapter.this.pagosAdapter.notifyItemRangeChanged(PrestamosAdapter.this.pagos.size(), 1);
        }

        private void getInfo(String prestamo_id, final int position, final TextView tvSemanasPendientes, final TextView tvSemanasAtraso) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"pagosPrestamo");
                data.put("prestamo_id", (Object)prestamo_id);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Pago pago = (Pago)gson.fromJson(obj.toString(), Pago.class);
                            PrestamosAdapter.this.pagos2.add(pago);
                        }
                        double suma_pendiente = 0.0;
                        for (Pago pago : PrestamosAdapter.this.pagos2) {
                            suma_pendiente += Utils.convertirDouble(pago.getCantidad_pendiente());
                        }
                        ArrayList<Pago> pagosConStatusNegativo = new ArrayList<Pago>();
                        for (Pago pago : PrestamosAdapter.this.pagos2) {
                            if (!pago.getStatus().equals("-1") && pago.getCantidad_pendiente().equals("0.00")) continue;
                            pagosConStatusNegativo.add(pago);
                        }
                        PrestamosViewHolder.this.showVerInfo(position, suma_pendiente, pagosConStatusNegativo, tvSemanasPendientes, tvSemanasAtraso);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void getPagos2(String prestamo_id, final int position) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", (Object)"pagosPrestamo");
                data.put("prestamo_id", (Object)prestamo_id);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            JSONObject obj = data.getJSONObject(i);
                            Gson gson = new Gson();
                            Pago pago = (Pago)gson.fromJson(obj.toString(), Pago.class);
                            PrestamosAdapter.this.pagos2.add(pago);
                        }
                        double suma_pendiente = 0.0;
                        for (Pago pago : PrestamosAdapter.this.pagos2) {
                            suma_pendiente += Utils.convertirDouble(pago.getCantidad_pendiente());
                        }
                        ArrayList<Pago> pagosConStatusNegativo = new ArrayList<Pago>();
                        for (Pago pago : PrestamosAdapter.this.pagos2) {
                            if (!pago.getStatus().equals("-1") && pago.getCantidad_pendiente().equals("0.00")) continue;
                            pagosConStatusNegativo.add(pago);
                        }
                        PrestamosViewHolder.this.showTicketDialog(position, suma_pendiente, pagosConStatusNegativo);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void showTicketDialog(int position, double suma_pendiente, List<Pago> pagosConStatusNegativo) {
            ArrayList<String> semanas_atraso = new ArrayList<String>();
            for (Pago pago : pagosConStatusNegativo) {
                semanas_atraso.add("SEM " + pago.getSemana());
            }
            int multas3 = 0;
            double multaPorSemana = 50.0;
            double sum_recargos = 0.0;
            double monto_tot = 0.0;
            NumberFormat formatoMoneda = NumberFormat.getCurrencyInstance(Locale.getDefault());
            String montoFormateado = formatoMoneda.format(suma_pendiente);
            String nombre = PrestamosAdapter.this.sesion.getString("nombre", "");
            String telefono = PrestamosAdapter.this.sesion.getString("telefono", "");
            final String colocadora_ticket = "\n COLOCADORA: " + new String(PrestamosAdapter.this.prestamos.get(position).getNombre_colocadora().getBytes(), StandardCharsets.UTF_8);
            final String titulo_ticket = "PRESTAMO GRUSEF S.A DE C.V";
            final String ruta_ticket = "\n RUTA: " + PrestamosAdapter.this.prestamos.get(position).getNombre_ruta();
            final String poblacion_ticket = "\n POBLACION: " + new String(PrestamosAdapter.this.prestamos.get(position).getNombre_poblacion().getBytes(), StandardCharsets.UTF_8);
            final String nombre_ticket = "\n CLIENTE: " + new String(PrestamosAdapter.this.prestamos.get(position).getNombre_completo().getBytes(), StandardCharsets.UTF_8);
            final String aval_ticket = "\n AVAL: " + new String(PrestamosAdapter.this.prestamos.get(position).getNombre_aval().getBytes(), StandardCharsets.UTF_8);
            final String atraso_ticket = "\n MONTO PENDIENTE: " + montoFormateado;
            final String pago_ticket = "\n SEMANAS DE ATRASO: " + semanas_atraso;
            multas3 = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes());
            sum_recargos = multaPorSemana * (double)multas3;
            String montoFormateado2 = formatoMoneda.format(sum_recargos);
            Log.d((String)"DEBUG", (String)("Antes de RECARGOS multas3: " + multas3));
            Log.d((String)"DEBUG", (String)("Antes de RECARGOS multaPorSemana: " + multaPorSemana));
            Log.d((String)"DEBUG", (String)("Antes de RECARGOS sum_recargos: " + sum_recargos));
            Log.d((String)"DEBUG", (String)("Antes de RECARGOS: " + montoFormateado2));
            monto_tot = sum_recargos + suma_pendiente;
            Log.d((String)"DEBUG", (String)("Antes de RECARGOS monto_tot: " + monto_tot));
            NumberFormat formatoMoneda3 = NumberFormat.getCurrencyInstance(Locale.getDefault());
            String montoFormateado3 = formatoMoneda3.format(monto_tot);
            final String recargos_ticket = "\n RECARGOS: " + montoFormateado2;
            final String monto_tot_ticket = "\n PAGO REQUERIDO: " + montoFormateado3;
            Log.d((String)"DEBUG", (String)("Antes de clear PAGOS: " + monto_tot_ticket));
            final String aviso = "\nESTIMADO CLIENTE\n\nES DE SUMA IMPORTANCIA\nRECORDARLE QUE SU CREDITO\nPRESENTA SEMANAS PENDIENTES\nPOR PAGAR LE SUGERIMOS PONERSE\nAL CORRIENTE Y ASI EVITAR\nPROBLEMAS LEGALES EN SU CONTRA.\n\nPOR FAVOR NO HAGA CASO OMISO\nO NOS VEREMOS EN LA NECESIDAD DE\nSOLICITAR LA LIQUIDACION\n DE SU CUENTA\nGRACIAS.\n\nLA SOLUCION ESTA EN SUS MANOS\nNO LAS DEJE EN LAS NUESTRAS!\n\nPARA COMUNICARSE CON NOSOTROS\n\n";
            final String avisoPDF = "\nESTIMADO CLIENTE:\nES DE SUMA IMPORTANCIA RECORDARLE QUE SU CREDITO PRESENTA SEMANAS PENDIENTES POR PAGAR, LE SUGERIMOS PONERSE AL CORRIENTE Y ASI EVITAR PROBLEMAS LEGALES EN SU CONTRA.\n\nPOR FAVOR NO HAGA CASO OMISO O NOS VEREMOS EN LA NECESIDAD DE SOLICITAR LA LIQUIDACION DE SU CUENTA\nGRACIAS.\n\nLA SOLUCION ESTA EN SUS MANOS NO LAS DEJE EN LAS NUESTRAS!\n\nPARA COMUNICARSE CON NOSOTROS\n\n";
            final String empleado_ticket = "GESTOR: " + nombre + "\nCEL: " + telefono;
            final String aviso2 = "OFICINAS: LIC. RODRIGO GONZALEZ\nCEL: 8714756305 ";
            TextView tituloTextView = new TextView(PrestamosAdapter.this.context);
            tituloTextView.setText((CharSequence)titulo_ticket);
            tituloTextView.setTypeface(null, 1);
            TextView rutaTextView = new TextView(PrestamosAdapter.this.context);
            rutaTextView.setText((CharSequence)ruta_ticket);
            TextView poblacionTextView = new TextView(PrestamosAdapter.this.context);
            poblacionTextView.setText((CharSequence)poblacion_ticket);
            TextView colocadoraTextView = new TextView(PrestamosAdapter.this.context);
            colocadoraTextView.setText((CharSequence)colocadora_ticket);
            TextView nombreTextView = new TextView(PrestamosAdapter.this.context);
            nombreTextView.setText((CharSequence)nombre_ticket);
            TextView avalTextView = new TextView(PrestamosAdapter.this.context);
            avalTextView.setText((CharSequence)aval_ticket);
            TextView atrasoTextView = new TextView(PrestamosAdapter.this.context);
            atrasoTextView.setText((CharSequence)atraso_ticket);
            TextView pagoTextView = new TextView(PrestamosAdapter.this.context);
            pagoTextView.setText((CharSequence)pago_ticket);
            TextView avisoTextView = new TextView(PrestamosAdapter.this.context);
            avisoTextView.setText((CharSequence)recargos_ticket);
            TextView totTextView = new TextView(PrestamosAdapter.this.context);
            totTextView.setText((CharSequence)monto_tot_ticket);
            totTextView.setTypeface(null, 1);
            LinearLayout linearLayout = new LinearLayout(PrestamosAdapter.this.context);
            linearLayout.setOrientation(1);
            linearLayout.addView((View)tituloTextView);
            linearLayout.addView((View)rutaTextView);
            linearLayout.addView((View)poblacionTextView);
            linearLayout.addView((View)colocadoraTextView);
            linearLayout.addView((View)nombreTextView);
            linearLayout.addView((View)atrasoTextView);
            linearLayout.addView((View)pagoTextView);
            linearLayout.addView((View)avisoTextView);
            linearLayout.addView((View)totTextView);
            AlertDialog.Builder builder5 = new AlertDialog.Builder(PrestamosAdapter.this.context);
            builder5.setView((View)linearLayout).setPositiveButton((CharSequence)"Imprimir", new DialogInterface.OnClickListener(){

                @RequiresApi(api=26)
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    BluetoothUtils.context = PrestamosAdapter.this.context;
                    BluetoothUtils.printPhoto(2131230871);
                    try {
                        BluetoothUtils.printText(titulo_ticket, ruta_ticket, poblacion_ticket, nombre_ticket, atraso_ticket, pago_ticket, aviso, aviso2, empleado_ticket, colocadora_ticket, aval_ticket, recargos_ticket, monto_tot_ticket);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).setNeutralButton((CharSequence)"Compartir", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PrestamosAdapter.this.fragment.compartirTexto(titulo_ticket, ruta_ticket, poblacion_ticket, nombre_ticket, atraso_ticket, pago_ticket, avisoPDF, aviso2, empleado_ticket, colocadora_ticket, aval_ticket, recargos_ticket, monto_tot_ticket);
                }
            }).setNegativeButton((CharSequence)"Cancelar", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            AlertDialog previewDialog = builder5.create();
            previewDialog.show();
        }

        private void showVerInfo(int position, double suma_pendiente, List<Pago> pagosConStatusNegativo, TextView tvSemanasPendientes, TextView tvSemanasAtraso) {
            ArrayList<String> semanas_atraso = new ArrayList<String>();
            for (Pago pago : pagosConStatusNegativo) {
                semanas_atraso.add("SEM " + pago.getSemana());
            }
            NumberFormat formatoMoneda = NumberFormat.getCurrencyInstance(new Locale("es", "MX"));
            String montoFormateado = formatoMoneda.format(suma_pendiente);
            String ruta_ticket = "\n RUTA: " + PrestamosAdapter.this.prestamos.get(position).getNombre_ruta();
            String atraso_ticket = montoFormateado;
            String pago_ticket = "" + semanas_atraso;
            int multas3 = Integer.parseInt(PrestamosAdapter.this.prestamos.get(position).getTiene_pendientes());
            double multaPorSemana = 50.0;
            double sum_recargos = multaPorSemana * (double)multas3;
            String montoFormateado2 = formatoMoneda.format(sum_recargos);
            double monto_tot = sum_recargos + suma_pendiente;
            NumberFormat formatoMoneda3 = NumberFormat.getCurrencyInstance(Locale.getDefault());
            String montoFormateado3 = formatoMoneda3.format(monto_tot);
            String recargos_ticket = "\n RECARGOS: " + montoFormateado2;
            String monto_tot_ticket = "\n PAGO REQUERIDO: " + montoFormateado3;
            tvSemanasPendientes.setText((CharSequence)Html.fromHtml((String)("<b>SEMANAS DE ATRASO:</b><br>" + pago_ticket)));
            tvSemanasAtraso.setText((CharSequence)Html.fromHtml((String)("<b>MONTO PENDIENTE:</b><br>" + atraso_ticket)));
        }

        private void getFecha(final String prestamo_id, String semana) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data2 = new JSONObject();
            Log.d((String)"DEBUG", (String)("Antes de clear PAGOS: " + prestamo_id + " / " + semana));
            try {
                data2.put("func", (Object)"pagosPrestamo_fecha");
                data2.put("prestamo_id", (Object)prestamo_id);
                data2.put("semana", (Object)semana);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data2, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    Log.d((String)"DEBUG", (String)("Respuesta JSON: " + response.toString()));
                    try {
                        if (response.has("data")) {
                            JSONArray dataArray = response.getJSONArray("data");
                            if (dataArray.length() > 0) {
                                JSONObject firstDataObject = dataArray.getJSONObject(0);
                                if (firstDataObject.has("fecha_pago")) {
                                    String fecha = firstDataObject.getString("fecha_pago");
                                    Log.d((String)"DEBUG", (String)("Listas con datos: " + PrestamosAdapter.this.pathsGarantiasRetiradas + "/" + PrestamosAdapter.this.archivosGeneral));
                                    PrestamosAdapter.this.subirGarantiasRetiradas(fecha, prestamo_id, PrestamosAdapter.this.pathsGarantiasRetiradas, (ArrayList)PrestamosAdapter.this.archivosGeneral, "");
                                    PrestamosAdapter.this.pathsGarantiasRetiradas.clear();
                                    PrestamosAdapter.this.archivosGeneral.clear();
                                    Log.d((String)"DEBUG", (String)("Listas con vacias despues del insert: " + PrestamosAdapter.this.pathsGarantiasRetiradas + "/" + PrestamosAdapter.this.archivosGeneral));
                                } else {
                                    Log.d((String)"DEBUG", (String)"No se pudo obtener la fecha de pago en el primer objeto");
                                }
                            } else {
                                Log.d((String)"DEBUG", (String)"El arreglo 'data' est\u00e1 vac\u00edo");
                            }
                        } else {
                            Log.d((String)"DEBUG", (String)"Respuesta JSON no contiene 'data'");
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        Log.d((String)"DEBUG", (String)"Error al analizar la respuesta JSON");
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    Log.d((String)"ERROR", (String)"Error de red al obtener la fecha de pago", (Throwable)error);
                    if (ErrorChecker.checker(error, PrestamosAdapter.this.context) == 1 || ErrorChecker.checker(error, PrestamosAdapter.this.context) == 4) {
                        // empty if block
                    }
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(2500, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void pagar(final Prestamo prestamo, final String prestamo_id2, final String pago_recibido, final String pago_multa, final String concepto, String fecha_pago, final String folio, final String semana, final String tipo_pago, Prestamo prestamo1) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            String status_folio = "";
            if (pago_multa.equals("0.00") && !pago_recibido.equals("0.00")) {
                status_folio = "1";
            }
            if (!pago_multa.equals("0.00") && !pago_recibido.equals("0.00")) {
                status_folio = "3";
            }
            try {
                data.put("func", (Object)"pagarSemana");
                data.put("prestamo_id", (Object)prestamo_id2);
                data.put("semana", (Object)semana);
                data.put("folio", (Object)folio);
                data.put("pago_recibido", (Object)pago_recibido);
                data.put("concepto", (Object)concepto);
                data.put("pago_multa", (Object)pago_multa);
                data.put("empleado_id", (Object)PrestamosAdapter.this.sesion.getString("id", "0"));
                data.put("tipo_pago", (Object)tipo_pago);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            final String finalStatus_folio = status_folio;
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        if (response.getString("status").equals("success")) {
                            String updatedAt = response.getJSONObject("data").getString("updated_at");
                            Log.d((String)"DEBUG", (String)("Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt));
                            PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo_id2), semana, tipo_pago, finalStatus_folio, PrestamosAdapter.this.sesion.getString("id", "0"), concepto, pago_recibido, pago_multa, tipo_pago, "on", folio, updatedAt);
                            LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                            View dialogView = inflater.inflate(2131492944, null);
                            TextView messageText = (TextView)dialogView.findViewById(2131296802);
                            messageText.setText((CharSequence)"Se ingresaron los datos correctamente.");
                            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                            builder.setView(dialogView);
                            AlertDialog confirmationDialog = builder.create();
                            confirmationDialog.show();
                            new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, PrestamosAdapter.this.context) == 1 || ErrorChecker.checker(error, PrestamosAdapter.this.context) == 4) {
                        PrestamosViewHolder.this.actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo_id2), semana, tipo_pago, finalStatus_folio, PrestamosAdapter.this.sesion.getString("id", "0"), concepto, pago_recibido, pago_multa, tipo_pago, "off", folio, "");
                        PrestamosViewHolder.this.cargarPrestamosConsulta();
                        LayoutInflater inflater = (LayoutInflater)PrestamosAdapter.this.context.getSystemService("layout_inflater");
                        View dialogView = inflater.inflate(2131492944, null);
                        TextView messageText = (TextView)dialogView.findViewById(2131296802);
                        messageText.setText((CharSequence)"Se perdio la conexi\u00f3n, se guardaron los datos en local.");
                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(PrestamosAdapter.this.context);
                        builder.setView(dialogView);
                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000L);
                    }
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(10000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        private void siguienteFolio(final TextInputLayout tlFolio) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            PrestamosAdapter.this.semanasPagadasList = new ArrayList();
            try {
                data.put("func", (Object)"siguienteFolio");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                public void onResponse(JSONObject response) {
                    try {
                        JSONObject obj = response.getJSONObject("data");
                        tlFolio.getEditText().setText((CharSequence)obj.get("folio_consecutivo").toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            requestQueue.add((Request)request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cargarSemanas(String prestamo_id) {
            PrestamosAdapter.this.semanasAdelantadasList = new ArrayList();
            PrestamosAdapter.this.semanasPagadasConMultaList = new ArrayList();
            PrestamosAdapter.this.semanasNoPagadasList = new ArrayList();
            PrestamosAdapter.this.semanasPagadasList = new ArrayList();
            DatabaseHelper dbHelper = new DatabaseHelper(PrestamosAdapter.this.context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            Cursor cursor = null;
            Log.d((String)"DEBUG", (String)("DATO DE PRESTAMO EN cargarSemanas prestamo_id....................: " + prestamo_id));
            try {
                String query = "SELECT * FROM pagos WHERE prestamo_id = ? AND (status = '4' OR status = '3' OR status = '-1' OR (status = '1' AND cantidad_pendiente = '0.00'))";
                cursor = db.rawQuery(query, new String[]{prestamo_id});
                if (cursor != null && cursor.moveToFirst()) {
                    Log.d((String)"DEBUG", (String)"El cursor tiene registros, empezando a iterar.");
                    do {
                        Semana semana = new Semana();
                        semana.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                        semana.setPrestamo_id(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id")));
                        semana.setCantidad_esperada_pago(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_esperada_pago")));
                        semana.setCantidad_normal_pagada(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_normal_pagada")));
                        semana.setCantidad_multa(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_multa")));
                        semana.setCantidad_pendiente(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_pendiente")));
                        semana.setCantidad_total_pagada(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_total_pagada")));
                        semana.setConcepto(cursor.getString(cursor.getColumnIndexOrThrow("concepto")));
                        semana.setFecha_pago(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago")));
                        semana.setFecha_pago_realizada(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago_realizada")));
                        semana.setFolio(cursor.getString(cursor.getColumnIndexOrThrow("folio")));
                        semana.setSemana(cursor.getString(cursor.getColumnIndexOrThrow("semana")));
                        semana.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                        semana.setStatus(cursor.getString(cursor.getColumnIndexOrThrow("status")));
                        semana.setUpdated_at(cursor.getString(cursor.getColumnIndexOrThrow("updated_at")));
                        semana.setTipo_pago(cursor.getString(cursor.getColumnIndexOrThrow("tipo_pago")));
                        if ("4".equals(semana.getStatus())) {
                            PrestamosAdapter.this.semanasAdelantadasList.add(semana);
                            Log.d((String)"DEBUG", (String)("Semana adelantada agregada: " + semana.getSemana()));
                            continue;
                        }
                        if ("3".equals(semana.getStatus())) {
                            PrestamosAdapter.this.semanasPagadasConMultaList.add(semana);
                            Log.d((String)"DEBUG", (String)("Semana con multa agregada: " + semana.getSemana()));
                            continue;
                        }
                        if ("-1".equals(semana.getStatus())) {
                            PrestamosAdapter.this.semanasNoPagadasList.add(semana);
                            Log.d((String)"DEBUG", (String)("Semana no pagada agregada: " + semana.getSemana()));
                            continue;
                        }
                        if (!"1".equals(semana.getStatus()) || !"0.00".equals(semana.getCantidad_pendiente())) continue;
                        PrestamosAdapter.this.semanasPagadasList.add(semana);
                        Log.d((String)"DEBUG", (String)("Semana pagada agregada: " + semana.getSemana()));
                    } while (cursor.moveToNext());
                    if (Build.VERSION.SDK_INT >= 24) {
                        new Handler(Looper.getMainLooper()).post(() -> {
                            this.colorearSemanas(PrestamosAdapter.this.semanasAdelantadasList, PrestamosAdapter.this.context.getResources().getColor(2131100446), PrestamosAdapter.this.context.getResources().getColor(2131100470), false);
                            this.colorearSemanas(PrestamosAdapter.this.semanasPagadasConMultaList, PrestamosAdapter.this.context.getResources().getColor(2131100468), PrestamosAdapter.this.context.getResources().getColor(2131099681), false);
                            this.colorearSemanas(PrestamosAdapter.this.semanasNoPagadasList, PrestamosAdapter.this.context.getResources().getColor(2131099717), PrestamosAdapter.this.context.getResources().getColor(2131100470), true);
                            this.colorearSemanas(PrestamosAdapter.this.semanasPagadasList, PrestamosAdapter.this.context.getResources().getColor(2131100455), PrestamosAdapter.this.context.getResources().getColor(2131100470), false);
                        });
                    }
                } else {
                    Log.d((String)"DEBUG", (String)"El cursor est\u00e1 vac\u00edo, no se encontraron semanas.");
                }
            }
            catch (Exception e) {
                Log.d((String)"DEBUG", (String)("Error al obtener las semanas: " + e));
                e.printStackTrace();
                Toast.makeText((Context)PrestamosAdapter.this.context, (CharSequence)"Error al obtener las semanas", (int)0).show();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                db.close();
            }
        }

        private void semanasPendientes(String prestamo_id) {
            VolleyS vs = VolleyS.getInstance(PrestamosAdapter.this.context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            PrestamosAdapter.this.semanasPendientesList = new ArrayList();
            try {
                data.put("func", (Object)"semanasPendientes");
                data.put("prestamo_id", (Object)prestamo_id);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(1, API.urlPagos, data, (Response.Listener)new Response.Listener<JSONObject>(){

                @RequiresApi(api=24)
                public void onResponse(JSONObject response) {
                    try {
                        JSONArray data = (JSONArray)response.get("data");
                        for (int i = 0; i < data.length(); ++i) {
                            Gson gson = new Gson();
                            JSONObject obj = data.getJSONObject(i);
                            Semana semana = (Semana)gson.fromJson(obj.toString(), Semana.class);
                            PrestamosAdapter.this.semanasPendientesList.add(semana);
                        }
                        PrestamosViewHolder.this.colorearSemanas(PrestamosAdapter.this.semanasPendientesList, PrestamosAdapter.this.context.getResources().getColor(2131100455), PrestamosAdapter.this.context.getResources().getColor(2131100470), true);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, PrestamosAdapter.this.context);
                }
            });
            request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(30000, 1, 1.0f));
            request.setShouldCache(false);
            requestQueue.add((Request)request);
        }

        @RequiresApi(api=24)
        private void colorearSemanas(ArrayList<Semana> semanasList, int color2, int textColor, boolean enable) {
            for (Semana sem : semanasList) {
                if (!PrestamosAdapter.this.semanasGeneradas.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) continue;
                Semana semanaEncontrada = PrestamosAdapter.this.semanasGeneradas.stream().filter(s -> s.getSemana().equals(sem.getSemana())).findAny().orElse(null);
                semanaEncontrada.btnSemana.setBackgroundColor(color2);
                semanaEncontrada.btnSemana.setTextColor(textColor);
                semanaEncontrada.setCantidad_pendiente(sem.getCantidad_pendiente());
                semanaEncontrada.btnSemana.setEnabled(enable);
                if (!sem.getCantidad_pendiente().equals("0.00")) {
                    semanaEncontrada.btnSemana.setEnabled(true);
                    semanaEncontrada.btnSemana.setText((CharSequence)(semanaEncontrada.btnSemana.getText() + "\n ($" + sem.getCantidad_pendiente() + ")"));
                    semanaEncontrada.btnSemana.setBackgroundColor(PrestamosAdapter.this.context.getResources().getColor(2131099717));
                    semanaEncontrada.btnSemana.setTextColor(PrestamosAdapter.this.context.getResources().getColor(2131100470));
                    continue;
                }
                semanaEncontrada.btnSemana.setText(semanaEncontrada.btnSemana.getText());
            }
        }

        public List<Button> getAllButtons(ViewGroup layout2) {
            ArrayList<Button> btn = new ArrayList<Button>();
            for (int i = 0; i < layout2.getChildCount(); ++i) {
                View v = layout2.getChildAt(i);
                if (!(v instanceof Button)) continue;
                btn.add((Button)v);
            }
            return btn;
        }
    }

    public static class CustomDialogFragment2
    extends DialogFragment {
        @Nullable
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            return inflater.inflate(2131492911, container, false);
        }

        public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            FragmentContainerView fragmentContainerView = (FragmentContainerView)view.findViewById(2131296860);
            ClientesAvalesFotosFragment fragment2 = new ClientesAvalesFotosFragment();
            Bundle args2 = this.getArguments();
            fragment2.setArguments(args2);
            this.getChildFragmentManager().beginTransaction().replace(fragmentContainerView.getId(), (Fragment)fragment2).commit();
            Button closeButton = (Button)view.findViewById(2131296497);
            closeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.dismiss();
                }
            });
        }
    }

    public static class CustomDialogFragment
    extends DialogFragment {
        @Nullable
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            return inflater.inflate(2131492911, container, false);
        }

        public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);
            FragmentContainerView fragmentContainerView = (FragmentContainerView)view.findViewById(2131296860);
            ClientesDocumentosFragment fragment = new ClientesDocumentosFragment();
            Bundle args = this.getArguments();
            fragment.setArguments(args);
            this.getChildFragmentManager().beginTransaction().replace(fragmentContainerView.getId(), (Fragment)fragment).commit();
            Button closeButton = (Button)view.findViewById(2131296497);
            closeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.dismiss();
                }
            });
        }
    }
}

