/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.models.Reporte;
import java.util.ArrayList;

public class ReporteAdapter
extends RecyclerView.Adapter<ReportesViewHolder> {
    Context context;
    ArrayList<Reporte> reportes;

    public ReporteAdapter(Context context, ArrayList<Reporte> reportes) {
        this.context = context;
        this.reportes = reportes;
    }

    @NonNull
    public ReportesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)this.context).inflate(2131493061, parent, false);
        return new ReportesViewHolder(v);
    }

    public void setListaFiltrada(ArrayList<Reporte> filteredList) {
        this.reportes = filteredList;
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(@NonNull ReportesViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public int getItemCount() {
        return this.reportes.size();
    }

    public void clear() {
        this.reportes.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<Reporte> list) {
        this.reportes = list;
        this.notifyDataSetChanged();
    }

    public class ReportesViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvPoblacion;
        TextView tvEstimado;
        TextView tvPagado;
        TextView tvFaltante;
        TextView tvCantidadPrestamos;

        public ReportesViewHolder(View itemView) {
            super(itemView);
            this.tvPoblacion = (TextView)itemView.findViewById(2131297319);
            this.tvEstimado = (TextView)itemView.findViewById(2131297285);
            this.tvPagado = (TextView)itemView.findViewById(2131297316);
            this.tvFaltante = (TextView)itemView.findViewById(2131297286);
            this.tvCantidadPrestamos = (TextView)itemView.findViewById(2131297269);
        }

        public void imprimir(int position) {
            this.tvPoblacion.setText((CharSequence)(ReporteAdapter.this.reportes.get(position).getNombre_poblacion() + " " + ReporteAdapter.this.reportes.get(position).getFecha_pago()));
            this.tvEstimado.setText((CharSequence)("$" + (ReporteAdapter.this.reportes.get(position).getEstimado() == null ? "0.0" : ReporteAdapter.this.reportes.get(position).getEstimado())));
            this.tvPagado.setText((CharSequence)("$" + (ReporteAdapter.this.reportes.get(position).getPagado() == null ? "0.0" : ReporteAdapter.this.reportes.get(position).getPagado())));
            this.tvFaltante.setText((CharSequence)("$" + (ReporteAdapter.this.reportes.get(position).getFaltante() == null ? "0.0" : ReporteAdapter.this.reportes.get(position).getFaltante())));
            this.tvCantidadPrestamos.setText((CharSequence)(ReporteAdapter.this.reportes.get(position).getCantidad_prestamos() == null ? "0" : ReporteAdapter.this.reportes.get(position).getCantidad_prestamos()));
        }
    }
}

