/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.models.ReporteCreditos;
import com.google.android.material.chip.Chip;
import com.google.android.material.chip.ChipGroup;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;
import java.util.ArrayList;

public class ReporteCreditosAdapter
extends RecyclerView.Adapter<ReporteCreditosViewHolder> {
    Context context;
    public ArrayList<ReporteCreditos> reportes;
    public ArrayList<ReporteCreditos> reportesSeleccionados = new ArrayList();
    public ArrayList<ReporteCreditos> reportesEditados = new ArrayList();
    public boolean buscarReporte = false;
    public ChipGroup chipGroup2;

    public ReporteCreditosAdapter(Context context, ArrayList<ReporteCreditos> reportes) {
        this.context = context;
        this.reportes = reportes;
    }

    public void setBuscarReporte(boolean buscarReporte) {
        this.buscarReporte = buscarReporte;
    }

    @NonNull
    public ReporteCreditosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)this.context).inflate(2131493059, parent, false);
        return new ReporteCreditosViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ReporteCreditosViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public void clear() {
        this.reportes.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteCreditos> list) {
        this.reportes = list;
        this.notifyDataSetChanged();
    }

    public void setListaFiltrada(ArrayList<ReporteCreditos> filteredList) {
        this.reportes = filteredList;
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.reportes.size();
    }

    public class ReporteCreditosViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvPoblacion;
        TextView tvEstimado;
        ConstraintLayout reporte_diario_item_bg;
        Button btnFormulario;

        public ReporteCreditosViewHolder(View itemView) {
            super(itemView);
            this.tvPoblacion = (TextView)itemView.findViewById(2131297319);
            this.tvEstimado = (TextView)itemView.findViewById(2131297285);
            this.btnFormulario = (Button)itemView.findViewById(2131296467);
            this.reporte_diario_item_bg = (ConstraintLayout)itemView.findViewById(2131296956);
        }

        public void imprimir(final int position) {
            this.tvPoblacion.setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getNombre_poblacion());
            this.tvEstimado.setText((CharSequence)"");
            if (ReporteCreditosAdapter.this.reportes.get(position).getSeleccionado()) {
                this.reporte_diario_item_bg.setBackgroundColor(ReporteCreditosAdapter.this.context.getResources().getColor(2131100434));
                if (!ReporteCreditosAdapter.this.buscarReporte) {
                    this.reporte_diario_item_bg.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View view) {
                            ReporteCreditosAdapter.this.reportes.get(position).setSeleccionado(false);
                            ReporteCreditosViewHolder.this.reporte_diario_item_bg.setBackgroundColor(ReporteCreditosAdapter.this.context.getResources().getColor(2131099771));
                            ReporteCreditosAdapter.this.reportesSeleccionados.remove(ReporteCreditosAdapter.this.reportes.get(position));
                            return false;
                        }
                    });
                }
            } else {
                this.reporte_diario_item_bg.setBackgroundColor(ReporteCreditosAdapter.this.context.getResources().getColor(2131099771));
            }
            this.btnFormulario.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    View dialogView = LayoutInflater.from((Context)ReporteCreditosAdapter.this.context).inflate(2131492939, null, false);
                    Button btnAgregar = (Button)dialogView.findViewById(2131296392);
                    final TextInputLayout tlObservaciones = (TextInputLayout)dialogView.findViewById(2131297207);
                    tlObservaciones.getEditText().setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getObservaciones());
                    final TextInputLayout tlMonto = (TextInputLayout)dialogView.findViewById(2131297197);
                    final TextInputLayout tlCantidad = (TextInputLayout)dialogView.findViewById(2131297158);
                    final TextInputLayout tlTotalPrestamos = (TextInputLayout)dialogView.findViewById(2131297241);
                    tlTotalPrestamos.getEditText().setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getTotal_prestamos());
                    final TextInputLayout tlPrestamosNuevos = (TextInputLayout)dialogView.findViewById(2131297222);
                    tlPrestamosNuevos.getEditText().setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getPrestamos_nuevos());
                    final TextInputLayout tlMontoNuevos = (TextInputLayout)dialogView.findViewById(2131297198);
                    tlMontoNuevos.getEditText().setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getMonto_nuevos());
                    final TextInputLayout tlPrestamosRenovados = (TextInputLayout)dialogView.findViewById(2131297223);
                    tlPrestamosRenovados.getEditText().setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getPrestamos_renovados());
                    final TextInputLayout tlMontoRenovados = (TextInputLayout)dialogView.findViewById(2131297199);
                    tlMontoRenovados.getEditText().setText((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getMonto_renovados());
                    final ChipGroup chipGroup = (ChipGroup)dialogView.findViewById(2131296487);
                    TextView tvCreditos = (TextView)dialogView.findViewById(2131297280);
                    if (ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados() != null) {
                        String[] creditosSplit = ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().trim().split("\\$");
                        for (int i = 0; i < creditosSplit.length; ++i) {
                            if (creditosSplit[i].equals("") || creditosSplit[i].equals("null ") || creditosSplit[i].equals(" ")) continue;
                            final Chip chip = new Chip(ReporteCreditosAdapter.this.context);
                            chip.setCloseIconVisible(true);
                            chip.setChipBackgroundColorResource(2131100429);
                            final String chipText = "$" + creditosSplit[i];
                            chip.setText((CharSequence)chipText);
                            chip.setOnCloseIconClickListener(new View.OnClickListener(){

                                public void onClick(View view) {
                                    ReporteCreditosAdapter.this.reportes.get(position).setCreditos_otorgados(ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().replace(chipText, ""));
                                    chipGroup.removeView((View)chip);
                                    String[] creditosSplit = ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().trim().split("\\$");
                                    int total = 0;
                                    for (int i = 0; i < creditosSplit.length; ++i) {
                                        if (creditosSplit[i].equals("") || creditosSplit[i].equals("null ") || creditosSplit[i].equals(" ")) continue;
                                        total += Integer.parseInt(creditosSplit[i].split(" ")[1].replace("(", "").replace(")", ""));
                                    }
                                    ReporteCreditosAdapter.this.reportes.get(position).setTotal_prestamos(String.valueOf(total));
                                    tlTotalPrestamos.getEditText().setText((CharSequence)String.valueOf(total));
                                }
                            });
                            chipGroup.addView((View)chip);
                        }
                    }
                    btnAgregar.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (!tlMonto.getEditText().getText().toString().equals("") && !tlCantidad.getEditText().getText().toString().equals("")) {
                                final String chipText = "$" + tlMonto.getEditText().getText().toString() + " (" + tlCantidad.getEditText().getText().toString() + ")";
                                boolean dataValid = true;
                                if (ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados() != null) {
                                    if (ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().contains(chipText) || ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().contains("$" + tlMonto.getEditText().getText().toString()) && ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados() != null) {
                                        Toast.makeText((Context)ReporteCreditosAdapter.this.context, (CharSequence)"Este monto ya fue ingresado", (int)0).show();
                                        dataValid = false;
                                    } else {
                                        dataValid = true;
                                    }
                                }
                                if (dataValid) {
                                    final Chip chip = new Chip(ReporteCreditosAdapter.this.context);
                                    chip.setCloseIconVisible(true);
                                    chip.setChipBackgroundColorResource(2131100429);
                                    chip.setText((CharSequence)chipText);
                                    chip.setOnCloseIconClickListener(new View.OnClickListener(){

                                        public void onClick(View view) {
                                            ReporteCreditosAdapter.this.reportes.get(position).setCreditos_otorgados(ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().replace(chipText, ""));
                                            chipGroup.removeView((View)chip);
                                        }
                                    });
                                    ReporteCreditosAdapter.this.reportes.get(position).setCreditos_otorgados(ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados() + " " + chipText);
                                    chipGroup.addView((View)chip);
                                    String[] creditosSplit = ReporteCreditosAdapter.this.reportes.get(position).getCreditos_otorgados().trim().split("\\$");
                                    int total = 0;
                                    for (int i = 0; i < creditosSplit.length; ++i) {
                                        if (creditosSplit[i].equals("") || creditosSplit[i].equals("null ") || creditosSplit[i].equals(" ")) continue;
                                        total += Integer.parseInt(creditosSplit[i].split(" ")[1].replace("(", "").replace(")", ""));
                                    }
                                    ReporteCreditosAdapter.this.reportes.get(position).setTotal_prestamos(String.valueOf(total));
                                    tlTotalPrestamos.getEditText().setText((CharSequence)String.valueOf(total));
                                    tlMonto.getEditText().setText((CharSequence)"");
                                    tlCantidad.getEditText().setText((CharSequence)"");
                                    tlMonto.requestFocus();
                                }
                            }
                        }
                    });
                    new MaterialAlertDialogBuilder(ReporteCreditosAdapter.this.context).setCancelable(false).setView(dialogView).setTitle((CharSequence)ReporteCreditosAdapter.this.reportes.get(position).getNombre_poblacion()).setPositiveButton((CharSequence)"Guardar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                            if (!ReporteCreditosAdapter.this.buscarReporte) {
                                ReporteCreditosAdapter.this.reportes.get(position).setSeleccionado(true);
                                ReporteCreditosViewHolder.this.reporte_diario_item_bg.setBackgroundColor(ReporteCreditosAdapter.this.context.getResources().getColor(2131100434));
                                if (!ReporteCreditosAdapter.this.reportesSeleccionados.contains(ReporteCreditosAdapter.this.reportes.get(position))) {
                                    ReporteCreditosAdapter.this.reportesSeleccionados.add(ReporteCreditosAdapter.this.reportes.get(position));
                                }
                                ReporteCreditosViewHolder.this.reporte_diario_item_bg.setOnLongClickListener(new View.OnLongClickListener(){

                                    public boolean onLongClick(View view) {
                                        ReporteCreditosAdapter.this.reportes.get(position).setSeleccionado(false);
                                        ReporteCreditosViewHolder.this.reporte_diario_item_bg.setBackgroundColor(ReporteCreditosAdapter.this.context.getResources().getColor(2131099771));
                                        ReporteCreditosAdapter.this.reportesSeleccionados.remove(ReporteCreditosAdapter.this.reportes.get(position));
                                        return false;
                                    }
                                });
                            }
                            ReporteCreditosAdapter.this.reportes.get(position).setObservaciones(tlObservaciones.getEditText().getText().toString());
                            ReporteCreditosAdapter.this.reportes.get(position).setTotal_prestamos(tlTotalPrestamos.getEditText().getText().toString());
                            ReporteCreditosAdapter.this.reportes.get(position).setPrestamos_nuevos(tlPrestamosNuevos.getEditText().getText().toString());
                            ReporteCreditosAdapter.this.reportes.get(position).setMonto_nuevos(tlMontoNuevos.getEditText().getText().toString());
                            ReporteCreditosAdapter.this.reportes.get(position).setPrestamos_renovados(tlPrestamosRenovados.getEditText().getText().toString());
                            ReporteCreditosAdapter.this.reportes.get(position).setMonto_renovados(tlMontoRenovados.getEditText().getText().toString());
                            if (ReporteCreditosAdapter.this.buscarReporte) {
                                ReporteCreditosAdapter.this.reportesEditados.add(ReporteCreditosAdapter.this.reportes.get(position));
                            }
                        }
                    }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int i) {
                        }
                    }).show();
                }
            });
        }
    }
}

