/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.models.ReporteGeneral;
import com.example.sefinsa_app.ui.reporteGeneral.ReporteGeneralFragment;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import java.text.ParseException;
import java.util.ArrayList;

public class ReporteGeneralAdapter
extends RecyclerView.Adapter<ReporteDiarioViewHolder> {
    Context context;
    ArrayList<ReporteGeneral> reporteGeneral;
    private final ReporteGeneralFragment fragment;

    public ReporteGeneralAdapter(Context context, ArrayList<ReporteGeneral> reporteGeneral, ReporteGeneralFragment fragment) {
        this.context = context;
        this.reporteGeneral = reporteGeneral;
        this.fragment = fragment;
    }

    @NonNull
    public ReporteDiarioViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)this.context).inflate(2131493060, parent, false);
        return new ReporteDiarioViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ReporteDiarioViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public void clear() {
        this.reporteGeneral.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteGeneral> list) {
        this.reporteGeneral = list;
        this.notifyDataSetChanged();
    }

    public void setListaFiltrada(ArrayList<ReporteGeneral> filteredList) {
        this.reporteGeneral = filteredList;
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.reporteGeneral.size();
    }

    public class ReporteDiarioViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvPoblacion;
        TextView tvFecha;
        TextView tvCliente;
        TextView tvFolio;
        TextView tvConcepto;
        TextView tvPago;
        TextView tvMulta;
        TextView tvPagoColumna;
        Button btnImprimir;

        public ReporteDiarioViewHolder(View itemView) {
            super(itemView);
            this.tvPoblacion = (TextView)itemView.findViewById(2131297319);
            this.tvFecha = (TextView)itemView.findViewById(2131297287);
            this.tvCliente = (TextView)itemView.findViewById(2131297272);
            this.tvFolio = (TextView)itemView.findViewById(2131297292);
            this.tvConcepto = (TextView)itemView.findViewById(2131297278);
            this.tvPago = (TextView)itemView.findViewById(2131297317);
            this.tvMulta = (TextView)itemView.findViewById(2131297309);
            this.btnImprimir = (Button)itemView.findViewById(2131296439);
            this.tvPagoColumna = (TextView)((Activity)ReporteGeneralAdapter.this.context).findViewById(2131297317);
        }

        public void imprimir(final int position) {
            this.tvPoblacion.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getNombre_poblacion());
            this.tvFecha.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getFecha_pago_realizada());
            this.tvCliente.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getNombre_completo());
            this.tvFolio.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getFolio());
            this.tvConcepto.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getConcepto());
            this.tvPago.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getPago());
            this.tvMulta.setText((CharSequence)ReporteGeneralAdapter.this.reporteGeneral.get(position).getPago_multa());
            this.btnImprimir.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    AlertDialog.Builder builder6 = new AlertDialog.Builder(ReporteGeneralAdapter.this.context);
                    builder6.setTitle((CharSequence)"Seleccionar Opcion").setPositiveButton((CharSequence)"Reimprimir Pago", new DialogInterface.OnClickListener(){

                        @RequiresApi(api=26)
                        public void onClick(DialogInterface dialog, int which) {
                            new MaterialAlertDialogBuilder(ReporteGeneralAdapter.this.context).setTitle((CharSequence)"Reimprimir pago").setMessage((CharSequence)("\u00bfQuieres reimprimir el pago de " + ReporteGeneralAdapter.this.reporteGeneral.get(position).getNombre_completo() + "?")).setPositiveButton((CharSequence)"S\u00ed", new DialogInterface.OnClickListener(){

                                @RequiresApi(api=26)
                                public void onClick(DialogInterface dialogInterface, int i) {
                                    BluetoothUtils.context = ReporteGeneralAdapter.this.context;
                                    BluetoothUtils.printPhoto(2131230871);
                                    try {
                                        BluetoothUtils.printReimpresion(ReporteGeneralAdapter.this.reporteGeneral.get(position));
                                    }
                                    catch (ParseException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            }).show();
                        }
                    }).setNeutralButton((CharSequence)"Compartir", new DialogInterface.OnClickListener(){

                        @RequiresApi(api=26)
                        public void onClick(DialogInterface dialog, int which) {
                            try {
                                ReporteGeneralAdapter.this.fragment.compartirPagoReporte(ReporteGeneralAdapter.this.reporteGeneral.get(position));
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                    }).setNegativeButton((CharSequence)"Cerrar", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                }
            });
        }
    }
}

