/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.content.Context;
import android.os.Build;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.recyclerview.widget.RecyclerView;
import com.example.sefinsa_app.models.ReporteHistorial;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class ReporteHistorialAdapter
extends RecyclerView.Adapter<ReportesHistorialViewHolder> {
    Context context;
    ArrayList<ReporteHistorial> reportes;
    private String modalidad_id;
    private int numSemanas;
    private boolean isHeaderCreated = false;

    public ReporteHistorialAdapter(Context context, ArrayList<ReporteHistorial> reportes) {
        this.context = context;
        this.reportes = reportes;
    }

    public void actualizarModalidad(String modalidad_id) {
        this.modalidad_id = modalidad_id;
        if (modalidad_id.equals("1")) {
            this.numSemanas = 15;
        } else if (modalidad_id.equals("2")) {
            this.numSemanas = 20;
        }
        this.notifyDataSetChanged();
    }

    @NonNull
    public ReportesHistorialViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)this.context).inflate(2131492977, parent, false);
        return new ReportesHistorialViewHolder(v);
    }

    public void setListaFiltrada(ArrayList<ReporteHistorial> filteredList) {
        this.reportes = filteredList;
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(@NonNull ReportesHistorialViewHolder holder, int position) {
        holder.imprimir(position);
    }

    public int getItemCount() {
        return this.reportes.size();
    }

    public void clear() {
        this.reportes.clear();
        this.notifyDataSetChanged();
    }

    public void addAll(ArrayList<ReporteHistorial> list) {
        this.reportes = list;
        this.notifyDataSetChanged();
    }

    public class ReportesHistorialViewHolder
    extends RecyclerView.ViewHolder {
        TableLayout tblSemanas;

        public ReportesHistorialViewHolder(View itemView) {
            super(itemView);
            this.tblSemanas = (TableLayout)itemView.findViewById(2131297123);
        }

        public void imprimir(int position) {
            int i;
            ReporteHistorial reporte = ReporteHistorialAdapter.this.reportes.get(position);
            TableRow rowData = new TableRow(this.itemView.getContext());
            String[] data = new String[]{reporte.getTarjeton(), reporte.getNombre_poblacion(), reporte.getNombre_completo(), reporte.getMonto_prestado(), reporte.getPago_semanal()};
            int[] widths = new int[]{200, 300, 590, 320, 290};
            for (i = 0; i < data.length; ++i) {
                TextView tvData = new TextView(this.itemView.getContext());
                tvData.setText((CharSequence)data[i]);
                tvData.setGravity(17);
                tvData.setTextSize(12.0f);
                tvData.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131099681));
                tvData.setPadding(10, 0, 10, 10);
                TableRow.LayoutParams layoutParams = new TableRow.LayoutParams(widths[i], 100);
                tvData.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                rowData.addView((View)tvData);
            }
            for (i = 1; i <= ReporteHistorialAdapter.this.numSemanas; ++i) {
                int colorFondo;
                String detalleSemana = reporte.getDetallesSemanas().get(i);
                if (detalleSemana == null) {
                    detalleSemana = "";
                }
                String fechaOriginal = "";
                if (detalleSemana.contains("<br>")) {
                    fechaOriginal = detalleSemana.split("<br>")[0];
                }
                String fechaFormateada = "";
                try {
                    if (!fechaOriginal.isEmpty()) {
                        SimpleDateFormat formatoEntrada = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                        SimpleDateFormat formatoSalida = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault());
                        Date fecha = formatoEntrada.parse(fechaOriginal);
                        if (fecha != null) {
                            fechaFormateada = formatoSalida.format(fecha);
                        }
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (java.text.ParseException e) {
                    throw new RuntimeException(e);
                }
                if (!fechaFormateada.isEmpty()) {
                    detalleSemana = detalleSemana.replace(fechaOriginal, fechaFormateada);
                }
                int estadoPago = reporte.getEstadoPagoSemana(i);
                switch (estadoPago) {
                    case -1: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131099716);
                        break;
                    }
                    case 4: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131100430);
                        break;
                    }
                    case 0: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131100470);
                        break;
                    }
                    case 1: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131100455);
                        break;
                    }
                    case 2: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131099770);
                        break;
                    }
                    case 3: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131100467);
                        break;
                    }
                    default: {
                        colorFondo = ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131100470);
                    }
                }
                TextView tvSemanaData = new TextView(this.itemView.getContext());
                if (Build.VERSION.SDK_INT >= 24) {
                    tvSemanaData.setText((CharSequence)Html.fromHtml((String)detalleSemana, (int)0));
                } else {
                    tvSemanaData.setText((CharSequence)Html.fromHtml((String)detalleSemana));
                }
                tvSemanaData.setGravity(17);
                tvSemanaData.setTextSize(12.0f);
                tvSemanaData.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)2131099681));
                tvSemanaData.setPadding(10, 0, 10, 30);
                tvSemanaData.setBackgroundColor(colorFondo);
                TableRow.LayoutParams layoutParams = new TableRow.LayoutParams(280, -2);
                tvSemanaData.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                rowData.addView((View)tvSemanaData);
            }
            this.tblSemanas.addView((View)rowData);
            this.tblSemanas.invalidate();
            this.tblSemanas.requestLayout();
        }
    }
}

