/*
 * Decompiled with CFR 0.152.
 */
package com.example.sefinsa_app.utilities;

import android.graphics.Bitmap;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Utils {
    private static Gson gson;
    public static final byte[] UNICODE_TEXT;
    private static final String hexStr = "0123456789ABCDEF";
    private static final String[] binaryArray;

    public static Gson getGsonParser() {
        if (null == gson) {
            GsonBuilder builder = new GsonBuilder();
            gson = builder.create();
        }
        return gson;
    }

    public static String formateDateFromstring(String inputFormat, String outputFormat, String inputDate) {
        Date parsed = null;
        String outputDate = "";
        SimpleDateFormat df_input = new SimpleDateFormat(inputFormat, Locale.getDefault());
        SimpleDateFormat df_output = new SimpleDateFormat(outputFormat, Locale.getDefault());
        try {
            parsed = df_input.parse(inputDate);
            outputDate = df_output.format(parsed);
        }
        catch (ParseException e) {
            Log.e((String)"DATE", (String)"ParseException - dateFormat");
        }
        return outputDate;
    }

    public static String trim(String string2) {
        return string2.replace(" ", "");
    }

    public static double parseDouble(String strNumber) {
        if (strNumber != null && strNumber.length() > 0) {
            try {
                return Double.parseDouble(strNumber);
            }
            catch (Exception e) {
                return -1.0;
            }
        }
        return 0.0;
    }

    public static int parseInt(String strNumber) {
        if (strNumber != null && strNumber.length() > 0) {
            try {
                return Integer.parseInt(strNumber);
            }
            catch (Exception e) {
                return -1;
            }
        }
        return 0;
    }

    public static Bitmap reduceBitmapSize(Bitmap bitmap, int MAX_SIZE) {
        int bitmapWidth;
        int bitmapHeight = bitmap.getHeight();
        double ratioSquare = bitmapHeight * (bitmapWidth = bitmap.getWidth()) / MAX_SIZE;
        if (ratioSquare <= 1.0) {
            return bitmap;
        }
        double ratio = Math.sqrt(ratioSquare);
        Log.d((String)"mylog", (String)("Ratio: " + ratio));
        int requiredHeight = (int)Math.round((double)bitmapHeight / ratio);
        int requiredWidth = (int)Math.round((double)bitmapWidth / ratio);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)requiredWidth, (int)requiredHeight, (boolean)true);
    }

    public static File getBitmapFile(Bitmap reducedBitmap, String path) {
        File file = new File(path);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        reducedBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
        byte[] bitmapdata = bos.toByteArray();
        try {
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bitmapdata);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static Bitmap generateThumb(Bitmap bitmap, int THUMB_SIZE) {
        int bitmapWidth;
        int bitmapHeight = bitmap.getHeight();
        double ratioSquare = bitmapHeight * (bitmapWidth = bitmap.getWidth()) / THUMB_SIZE;
        if (ratioSquare <= 1.0) {
            return bitmap;
        }
        double ratio = Math.sqrt(ratioSquare);
        Log.d((String)"mylog", (String)("Ratio: " + ratio));
        int requiredHeight = (int)Math.round((double)bitmapHeight / ratio);
        int requiredWidth = (int)Math.round((double)bitmapWidth / ratio);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)requiredWidth, (int)requiredHeight, (boolean)true);
    }

    public static byte[] decodeBitmap(Bitmap bmp) {
        int i;
        int maxWidth = 576;
        int maxHeight = 300;
        if (bmp.getWidth() > maxWidth || bmp.getHeight() > maxHeight) {
            bmp = Utils.scaleBitmapToMaxSize(bmp, maxWidth, maxHeight);
        }
        int bmpWidth = bmp.getWidth();
        int bmpHeight = bmp.getHeight();
        ArrayList<String> list = new ArrayList<String>();
        int bitLen = bmpWidth / 8;
        int zeroCount = bmpWidth % 8;
        String zeroStr = "";
        if (zeroCount > 0) {
            bitLen = bmpWidth / 8 + 1;
            for (i = 0; i < 8 - zeroCount; ++i) {
                zeroStr = zeroStr + "0";
            }
        }
        for (i = 0; i < bmpHeight; ++i) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < bmpWidth; ++j) {
                int color2 = bmp.getPixel(j, i);
                int r = color2 >> 16 & 0xFF;
                int g = color2 >> 8 & 0xFF;
                int b = color2 & 0xFF;
                if (r > 160 && g > 160 && b > 160) {
                    sb.append("0");
                    continue;
                }
                sb.append("1");
            }
            if (zeroCount > 0) {
                sb.append(zeroStr);
            }
            list.add(sb.toString());
        }
        List<String> bmpHexList = Utils.binaryListToHexStringList(list);
        String commandHexString = "1D763000";
        String widthHexString = Integer.toHexString(bmpWidth % 8 == 0 ? bmpWidth / 8 : bmpWidth / 8 + 1);
        if (widthHexString.length() > 2) {
            Log.e((String)"decodeBitmap error", (String)" width is too large");
            return null;
        }
        if (widthHexString.length() == 1) {
            widthHexString = "0" + widthHexString;
        }
        widthHexString = widthHexString + "00";
        String heightHexString = Integer.toHexString(bmpHeight);
        if (heightHexString.length() > 2) {
            Log.e((String)"decodeBitmap error", (String)" height is too large");
            return null;
        }
        if (heightHexString.length() == 1) {
            heightHexString = "0" + heightHexString;
        }
        heightHexString = heightHexString + "00";
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandHexString + widthHexString + heightHexString);
        commandList.addAll(bmpHexList);
        return Utils.hexList2Byte(commandList);
    }

    public static Bitmap scaleBitmapToMaxSize(Bitmap bmp, int maxWidth, int maxHeight) {
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        float ratio = Math.min((float)maxWidth / (float)width, (float)maxHeight / (float)height);
        int newWidth = (int)((float)width * ratio);
        int newHeight = (int)((float)height * ratio);
        return Bitmap.createScaledBitmap((Bitmap)bmp, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public static List<String> binaryListToHexStringList(List<String> list) {
        ArrayList<String> hexList = new ArrayList<String>();
        for (String binaryStr : list) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < binaryStr.length(); i += 8) {
                String str = binaryStr.substring(i, i + 8);
                String hexString = Utils.myBinaryStrToHexString(str);
                sb.append(hexString);
            }
            hexList.add(sb.toString());
        }
        return hexList;
    }

    public static String myBinaryStrToHexString(String binaryStr) {
        int i;
        String hex = "";
        String f4 = binaryStr.substring(0, 4);
        String b4 = binaryStr.substring(4, 8);
        for (i = 0; i < binaryArray.length; ++i) {
            if (!f4.equals(binaryArray[i])) continue;
            hex = hex + hexStr.substring(i, i + 1);
        }
        for (i = 0; i < binaryArray.length; ++i) {
            if (!b4.equals(binaryArray[i])) continue;
            hex = hex + hexStr.substring(i, i + 1);
        }
        return hex;
    }

    public static byte[] hexList2Byte(List<String> list) {
        ArrayList<byte[]> commandList = new ArrayList<byte[]>();
        for (String hexStr : list) {
            commandList.add(Utils.hexStringToBytes(hexStr));
        }
        byte[] bytes = Utils.sysCopy(commandList);
        return bytes;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(Utils.charToByte(hexChars[pos]) << 4 | Utils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte[] sysCopy(List<byte[]> srcArrays) {
        int len = 0;
        for (byte[] srcArray : srcArrays) {
            len += srcArray.length;
        }
        byte[] destArray = new byte[len];
        int destLen = 0;
        for (byte[] srcArray : srcArrays) {
            System.arraycopy(srcArray, 0, destArray, destLen, srcArray.length);
            destLen += srcArray.length;
        }
        return destArray;
    }

    public static double convertirDouble(String numero) {
        if (numero == null || numero.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(numero.replace(",", "."));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private static byte charToByte(char c) {
        return (byte)hexStr.indexOf(c);
    }

    static {
        UNICODE_TEXT = new byte[]{35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35};
        binaryArray = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    }
}

